/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.session;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.jwt.Jwt;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionUtil {
    public static UserInfo getUser() {
        HttpServletRequest request = SessionUtil.getRequest();
        if (request == null) {
            return null;
        }
        Object user = request.getAttribute("_ACCEPT_USER_REQUEST_ATTR_");
        if (user == null && (user = SessionUtil.getUser(request)) != null) {
            request.setAttribute("_ACCEPT_USER_REQUEST_ATTR_", user);
        }
        return (UserInfo)user;
    }

    public static String getUserRealName() {
        UserInfo userInfo = SessionUtil.getUser();
        if (userInfo != null) {
            return userInfo.getRealName();
        }
        return "";
    }

    public static String getUserId() {
        UserInfo userInfo = SessionUtil.getUser();
        if (userInfo != null) {
            return userInfo.getUserGuid();
        }
        return "";
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static UserInfo getUser(HttpServletRequest request) {
        String token = request.getHeader("token");
        UserInfo userInfo = new UserInfo();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{token})) {
            Map<String, String> map = Jwt.getPayload(token);
            userInfo = (UserInfo)BeanConvertUtil.convertMap(map, UserInfo.class);
        }
        return userInfo;
    }
}

