package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.dto.sqxx.push.dj2.sqxx.fj.DiyixxDTO;
import cn.gtmap.hlw.core.dto.sqxx.push.dj2.sqxx.fj.FpxxDTO;
import cn.gtmap.hlw.core.dto.sqxx.wlzs.WlzsDTO;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 21:59
 * @description 申请信息保存聚合根
 */
@Data
public class SqxxSaveModelDTO {
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 按钮id
     */
    private String anid;
    /**
     * 步骤id
     */
    private String processId;
    /**
     * 原受理编号
     */
    private String ySlbh;

    //项目信息
    /**
     * 申请信息表
     */
    private SqxxDTO sqxx;
    /**
     * 权利人
     */
    @Valid
    private List<QlrDTO> qlrList;
    /**
     * 中介信息
     */
    private ZjxxDTO zjxx;
    /**
     * 资金监管
     */
    private ZjjgDTO zjjg;
    /**
     * 合同信息
     */
    private HtxxDTO htxx;
    /**
     * 申请信息预约信息
     */
    private SqxxYyxxDTO sqxxYyxx;
    /**
     * 认领信息
     */
    private RlxxDTO rlxx;
    /**
     * 税务信息
     */
    private SwxxDTO swxx;
    /**
     * 收费信息
     */
    private List<SfxxDTO> sfxxList;
    /**
     * 物流信息
     */
    private List<WlxxDTO> wlxxList;
    /**
     * 过户信息
     */
    private List<GhxxDTO> ghxxList;
    /**
     * 单位申请信息
     */
    private UnitSqxxDTO unitSqxx;

    //权利信息
    /**
     * 变更信息
     */
    private BgxxDTO bgxx;
    /**
     * 房屋信息
     */
    private FwxxDTO fwxx;
    /**
     * 房屋多幢信息
     */
    private List<FwxxDTO> ljzxx;
    /**
     * 外联证书
     */
    private WlzsDTO wlzs;
    /**
     * 附属设施信息
     */
    private List<FsssxxDTO> fsssxxList;
    /**
     * 构筑物信息
     */
    private GzwxxDTO gzwxx;
    /**
     * 林地信息
     */
    private LdxxDTO ldxx;
    /**
     * 土地信息
     */
    private TdxxDTO tdxx;
    /**
     * 地役信息
     */
    private DiyixxDTO diyixx;
    /**
     * 居住权
     */
    private JzqDTO jzq;
    /**
     * 抵押信息
     */
    private DyxxDTO dyxx;

    //限制信息
    /**
     * 查封信息
     */
    private CfxxDTO cfxx;
    /**
     * 异议信息
     */
    private YiyixxDTO yiyixx;
    /**
     * 预审台账状态信息
     */
    private YstzztDTO ystzzt;
    /**
     * 发票信息
     */
    private List<FpxxDTO> fpxxList;
    /**
     * 家庭集合
     */
    private List<JtDTO> JtList;
    /**
     * 裁定信息
     */
    private CdxxDTO cdxx;
    /**
     * 地籍调查
     */
    private DjdcDTO djdc;
}
