package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.BasePage;
import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.model.GxYyCustomNews;

import java.util.List;

/**
 * (GxYyCustomNews)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-03 09:51:35
 */
public interface GxYyCustomNewsRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyCustomNews get(String id);

    /**
     * 新增数据
     *
     * @param gxYyCustomNews 实例对象
     * @return 影响行数
     */
    void save(GxYyCustomNews gxYyCustomNews);

    /**
     * 修改数据
     *
     * @param gxYyCustomNews 实例对象
     * @return 影响行数
     */
    void update(GxYyCustomNews gxYyCustomNews);

    /**
     * 获取数据
     *
     * @param sqlx 申请类型
     * @return 影响行数
     */
    GxYyCustomNews getBySqlx(String sqlx);

    /**
     * 获取数据
     *
     * @param type     类型
     * @param newsType 新闻类型
     * @param status   状态
     * @param basePage
     * @param typeList
     * @return 影响行数
     */
    PageInfo<GxYyCustomNews> getByParams(String type, String newsType, String status, BasePage basePage, List<String> typeList);

    /**
     * 新闻树形结构
     * @param newsType
     * @param typeList
     * @return:List<GxYyCustomNews>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyCustomNews> tree(String newsType, List<String> typeList);
    /**
     * 获取数据
     * @param sqlx
     * @param newsType
     * @param typeList
     * @return:GxYyCustomNews
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyCustomNews getBySqlxAndNewType(String sqlx, String newsType, List<String> typeList);
}

