package cn.gtmap.hlw.core.dto.sqxx.bdcdyxx;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.gtmap.hlw.core.dto.sqxx.save.FsssxxDTO;
import cn.gtmap.hlw.core.dto.sqxx.save.QlrDTO;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/29
 * @description
 */
@Data
public class BdcdyxxSaveParamsDTO {
    /**
     * 申请id
     */
    private String sqid;
    /**
     * 受理编号
     */
    private String slbh;
    /**
     * 产权证号
     */
    private String cqzh;
    /**
     * 土地证号
     */
    private String tdzh;
    /**
     * 查封范围
     */
    private String cffw;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 幢号
     */
    private String fwzh;
    /**
     * 房间号
     */
    private String fwfh;
    /**
     * 建筑面积
     */
    private String jzmj;
    /**
     * 竣工日期
     */
    private String jgsj;
    /**
     * 小区名称
     */
    private String xqmc;
    /**
     * 房屋类型
     */
    private String fwlx;
    /**
     * 房屋类型名称
     */
    @ZdTypeConfig(field = "fwlx", tableName = ZdTypeConstant.ZD_TYPE_FWLX, dmToMc = true)
    private String fwlxmc;
    /**
     * 总层数
     */
    private String fwzcs;
    /**
     * 土地使用权起始时间
     */
    private String tdsyqssj;
    /**
     * 土地使用权结束时间
     */
    private String tdsyjssj;
    /**
     * 土地使用权类型
     */
    private String tdsyqlx;
    /**
     * 土地用途
     */
    private String tdyt;
    /**
     * 宗地面积
     */
    private String zdmj;
    /**
     * 房屋用途
     */
    private String fwyt;
    /**
     * 房屋用途名称
     */
    @ZdTypeConfig(field = "fwyt", tableName = ZdTypeConstant.ZD_TYPE_FWYT, dmToMc = true)
    private String fwytmc;
    /**
     * 规划用途
     */
    private String ghytdm;
    /**
     * 规划用途名称
     */
    @ZdTypeConfig(field = "ghytdm", tableName = ZdTypeConstant.ZD_TYPE_GHYT, dmToMc = true)
    private String ghytmc;
    /**
     * 所在层
     */
    private String fwszc;
    /**
     * 房屋性质代码
     */
    private String fwxz;
    /**
     * 房屋性质名称
     */
    @ZdTypeConfig(field = "fwxz", tableName = ZdTypeConstant.ZD_TYPE_FWXZ, dmToMc = true)
    private String fwxzmc;
    /**
     * 套内建筑面积
     */
    private String sctnmj;
    /**
     * 房屋结构代码
     */
    private String fwjg;
    /**
     * 房屋结构名称
     */
    @ZdTypeConfig(field = "fwjg", tableName = ZdTypeConstant.ZD_TYPE_FWJG, dmToMc = true)
    private String fwjgmc;
    /**
     * 分摊土地面积
     */
    private String fttdmj;
    /**
     * 土地用途2
     */
    private String tdyt2;
    /**
     * 土地用途3
     */
    private String tdyt3;
    /**
     * 分摊建筑面积
     */
    private String scftmj;
    /**
     * 土地使用权起始时间2
     */
    private String tdsyqssj2;
    /**
     * 土地使用权结束时间2
     */
    private String tdsyjssj2;
    /**
     * 土地使用权起始时间3
     */
    private String tdsyqssj3;
    /**
     * 土地使用权结束时间3
     */
    private String tdsyjssj3;
    /**
     * 证明号
     */
    private String zmh;
    /**
     * 附记
     */
    private String fj;
    /**
     * 房屋实际层
     */
    private String fwsjc;
    /**
     * 权利性质代码
     */
    private String qlxzdm;
    /**
     * 土地所有权人
     */
    private String tdsyqr;

    /**
     * 承包面积
     * */
    private Double cbmj;

    /**
     * 地块名称
     * */
    private String dkmc;

    /**
     * 承包地类等级
     * */
    private String cbdldj;

    /**
     * 确权情况(1：确权确股，2：确权确地)
     * */
    private String qqqk;

    /**
     * 实测面积
     * */
    private Double scmj;

    /**
     * 地块编码
     * */
    private String dkbm;

    /**
     * 是否基本农田
     * */
    private String sfjbnt;
    /**
     * 权利人信息
     */
    private List<QlrDTO> qlrList;

    /**
     * 林种
     */
    private String lz;
    /**
     * 林地使用开始期限
     */
    private Date ldsyksqx;
    /**
     * 林地使用结束期限
     */
    private Date ldsyjsqx;
    /**
     * 林地使用期限是否永久
     */
    private String ldsyqxsfyj;
    /**
     * 主要树种
     */
    private String zysz;
    /**
     * 森林类别名称
     */
    private String sllbmc;
    /**
     * 森林类别代码
     */
    private String sllbdm;
    /**
     * 事权等级
     */
    private String sqdj;
    /**
     * 小地名
     */
    private String xdm;
    /**
     * 起源
     */
    private String qy;
    /**
     * 株数
     */
    private String zs;
    /**
     * 林班
     */
    private String lb;
    /**
     * 小班
     */
    private String xb;
    /**
     * 权利类型
     */
    private String qllx;
    /**
     * 造林年度
     */
    private String zlnd;
    /**
     * 项目id
     */
    private String xmid;
    /**
     * 面积
     */
    private String mj;
    /**
     * 发包方名称
     */
    private String fbfmc;
    /**
     * 森林、林木使用人
     */
    private String sllmsyr;
    /**
     * 森林、林木所有权人
     */
    private String sllmsyqr;
    /**
     * 不动产价值
     */
    private String bdcjz;

    /**
     * 评估价值
     */
    private String pgjz;

    /**
     * 最高债权额
     */
    private String zgzqe;

    /**
     * 被担保主债权数额
     */
    private String bdbzzqse;
    /**
     * 抵押方式
     */
    private String dyfs;
    /**
     * 附属设施信息
     */
    private List<FsssxxDTO> fsssxxList;
    /**
     * 不动产类型
     */
    private String bdclx;
    /**
     * 独用建筑面积
     */
    private String dyjzmj;
    /**
     * 分摊建筑面积
     */
    private String ftjzmj;
    /**
     * 独用土地面积
     */
    private String dytdmj;
    /**
     * 取得方式（存放代码）
     */
    private String qdfs;
    /**
     * 行政区划
     */
    private String xzqhdm;
    /**
     * 所在乡镇街道
     */
    private String szxzjd;
    /**
     * 买卖合同号
     */
    private String mmhth;
    /**
     * 交易价格
     */
    private String jyjg;
    /**
     * 土地使用权面积
     */
    private String tdsyqmj;
    /**
     * 宗地宗海权利类型代码（zd_type表对照）
     */
    private String zdzhqllx;
    /**
     * 宗地宗海权利性质
     */
    private String zdzhqlxz;
}
