/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiSecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiSecurityUtils.class);

    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) throws Exception {
        String sm4Key = Sm4Util.generateKey();
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";
        String dataEncrypt = "03e21d1701183f820150f3a6b32b2e195949fcf8002a41543fd9da4f5c9b7017a766af66d0d55024bc763024e9e248eafd2b74674401be9d5ce949fa0ecf3692ccd469b6c0f65185296b03fc59a688dac265fc7a03438d81366f985e82507975598efbead481031c0518be0dd8fe220d60c4bf85787317658e2f6b197e418cf4fac3b2b147fdd2d19d7c7cad225b76a0";
        String paramid = "04737ef7e44fd546db58c1277c9b69b6c6f7931743874d203f6bda35f64819d9424fd622759e0520562e59cc2918cf8ab6dd8c4c63ecf076ceb8c5ba916ce6bb2f309f9a9f4a17d5583a5fdc737e9d2775b512cb48b812085b742fada999dc200882c7fdcc5a11256e79a16b7e49029c2717e1e6c7b534e0ca10cb27a201e61f68a9709e4adebacae93f4d18af";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        String encryptStr = "{\"cqzh\":\"\u7696(2018)\u829c\u6e56\u5e02\u4e0d\u52a8\u4ea7\u6743\u7b2c0569026\u53f7\",\"xmid\":\"WHFDCQ17305628200521664614\"}";
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);
        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);
        System.out.println(JSON.toJSONString((Object)body));
    }
}

