package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyOrgCaRel;

import java.util.List;

/**
 * (GxYyOrgCaRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyOrgCaRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyOrgCaRel get(String id);

    /**
     * 新增数据
     *
     * @param gxYyOrgCaRel 实例对象
     * @return 影响行数
     */
    void save(GxYyOrgCaRel gxYyOrgCaRel);

    /**
     * 修改数据
     *
     * @param gxYyOrgCaRel 实例对象
     * @return 影响行数
     */
    void update(GxYyOrgCaRel gxYyOrgCaRel);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyOrgCaRel> getAll();

    /**
     * 删除数据
     *
     * @param id
     * @return 影响行数
     */
    int delete(String id);

    /**
     * 根据ca查询
     * @param ca
     * @param orgId
     * @return:GxYyOrgCaRel
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyOrgCaRel getByCa(String ca);
}

