package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/30
 * @description 共有方式
 */
@Getter
@AllArgsConstructor
public enum GyfsEnum {
    /**
     * 单独所有
     */
    DDSY("0", "单独所有"),
    /**
     * 共同共有
     */
    GTGY("1", "共同共有"),
    /**
     * 按份共有
     */
    AFGY("2", "按份共有"),
    /**
     * 其它共有
     */
    QTGY("3", "其它共有"),

    /**
     * 实名制
     */
    SMZ("4", "实名制");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (GyfsEnum xq : GyfsEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
