package cn.gtmap.hlw.core.dao.pz;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.dict.lcdy.LcdyListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/26
 * @description
 */
@Repository
public interface GxYyLcdyPzDao {
    /**
     * 根据sqlx查询
     *
     * @param sqlx
     * @return:List<GxYyLcdyPzPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyLcdyPz> listBySqlx(String sqlx);


    /**
     * 根据fjlx查询
     *
     * @param fjlx 附件类型
     * @return:List<GxYyLcdyPzPO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYyLcdyPz> listByFjlx(String fjlx);

    /**
     * 批量保存
     *
     * @param lcdyPzList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatchSomeColumn(List<GxYyLcdyPz> lcdyPzList);

    /**
     * 根据sqlx删除
     *
     * @param sqlx
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqlx(String sqlx);

    /**
     * 根据fjlx删除
     *
     * @param fjlx 附件类型
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void deleteByFjlx(String fjlx);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return
     */
    PageInfo<GxYyLcdyPz> queryPage(LcdyListParamsDTO paramsDTO);

    /**
     * 新增修改
     *
     * @param gxYyLcdyPzPO
     * @author wangchao
     */
    void saveOrUpdateDy(GxYyLcdyPz gxYyLcdyPzPO);

    /**
     * 删除
     *
     * @param pzid
     * @author wangchao
     */
    void delete(String pzid);

    void saveOrUpdateBatch(List<GxYyLcdyPz> lcdyPzPoList);
}
