package cn.gtmap.hlw.core.dto.sw.hs.td.ah;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.dto.sw.hs.clf.ah.TdcrjDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.QlrxxDTO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/12/20
 * @description
 */
@Data
public class AhSwHsTdQueryDTO {
    /**
     * 不动产权证号
     */
    private String bdcqzh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 丘号
     */
    private String qh;
    /**
     * 行政区划代码
     */
    @ZdDzConfig(field = "xzqhDm", tableName = ZdDzConstant.ZD_DZ_XZQH, dmToDm = true)
    private String xzqhDm;
    /**
     * 行政区划名称
     */
    @ZdDzConfig(field = "xzqhMc", tableName = ZdDzConstant.ZD_DZ_XZQH, dmToMc = true)
    private String xzqhMc;
    /**
     * 乡镇街道代码
     */
    @ZdDzConfig(field = "jdxzDm", tableName = ZdDzConstant.ZD_DZ_JDXZ, dmToDm = true)
    private String jdxzDm;
    /**
     * 乡镇街道代码
     */
    @ZdDzConfig(field = "jdxzMc", tableName = ZdDzConstant.ZD_DZ_JDXZ, dmToMc = true)
    private String jdxzMc;
    /**
     * 土地完整地址
     */
    private String tdwzdz;
    /**
     * 土地面积
     */
    private String tdmj;
    /**
     * 土地单价
     */
    private String tddj;
    /**
     * 交易日期
     */
    private String jyrq;
    /**
     * 业务受理单号
     */
    private String sldh;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 合同金额
     */
    private String htje;
    /**
     * 合同签订日期
     */
    private String htqdrq;
    /**
     * 经办人姓名
     */
    private String jbrxm;
    /**
     * 经办人电话
     */
    private String jbrdh;
    /**
     *  土地出让转让标记    “0”出让，“1”转让（不传默认“0”）
     */
    private String tdcrzrbz;
    /**
     *  出让方信息列表
     */
    private List<QlrxxDTO> crfxxlb;
    /**
     *  受让方信息列表
     */
    private List<QlrxxDTO> srfxxlb;
    /**
     * 土地出让金
     */
    private TdcrjDTO tdcrj;
    /**
     * 不动产部门的附记信息
     */
    private String fjxx;
    /**
     *  房屋信息备注
     */
    private String bz;
    /**
     * 房改房金额
     */
    private String fgfje;
    /**
     * 电子监管号
     */
    private String dzjgh;
}
