package cn.gtmap.hlw.core.dto.exchange.push;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 申请信息
 */
@Data
public class PushSqxxDTO {
    /**申请ID*/
    private String sqid;

    /**申请号*/

    private String sqh;

    /**登记类型;字典项*/
    private String djlx;

    /**申请登记类型（组合流程存放小类）*/
    private String sqdjlx;

    /**权利类型;字典项*/
    private String qllx;

    /**共有方式;字典项*/
    private String gyfs;

    /**是否分别持证 0:否  1:是*/
    private String sffbcz;

    private String bdcdyh;

    /**交易价格*/
    private Double jyjg;

    /**被担保主债权数额*/
    private Double bdbzzqse;

    /**债务履行期限开始日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date zwlxqxksrq;

    /**债务履行期限结束日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date zwlxqxjsrq;

    /**评估价值*/
    private Double pgjz;

    /**抵押范围*/
    private String dyfw;

    /**抵押方式;字典项*/
    private String dyfs;

    /**贷款方式;字典项*/
    private String dkfs;

    /**原不动产权证证号*/
    private String ybdcqzh;

    /**验证状态*/
    private Integer yzzt;

    /**导出状态*/
    private Integer dczt;

    /**申请状态 0：未审核，1：审核中，2：已通过，3：未通过，4：预审通过，5：预审未通过，6：用户撤回，7：办结，8：会签通过，9：已审核，10：会签不通过*/
    private Integer slzt;

    /**申请状态 0：未审核，1：审核中，2：已通过，3：未通过，4：预审通过，5：预审未通过，6：用户撤回，7：办结，8：会签通过，9：已审核，10：会签不通过*/
    private String slztmc;

    /**受理信息反馈信息也可以是验证的信息。*/
    private String slxx;

    /**备注(注销登记的注销原因也放在该字段)*/
    private String bz;

    /**创建用户*/
    private String createUser;

    /**创建用户真是姓名*/
    private String createUserRealName;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUserid;

    /**创建日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date createDate;

    /**管理员审核日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date editDate;

    /**不动产价值*/
    private Float bdcjz;

    /**坐落 */
    private String zl;

    /**抵押顺位*/
    private String dysw;

    /**申请证书版式*/
    private String sszsbs;

    /**不动产类型*/
    private String bdclx;

    @ZdTypeConfig(field = "bdclx", tableName = ZdTypeConstant.ZD_TYPE_BDCLX, dmToMc = true)
    private String bdclxmc;

    private Double mj;

    /**用途*/
    private String yt;

    /**宗地/宗海权利性质*/
    private String zdzhqlxz;

    /**宗地/宗海权利性质名称 */
    @ZdTypeConfig(field = "zdzhqlxz", tableName = ZdTypeConstant.ZD_TYPE_ZDZHQLLX, dmToMc = true)
    private String zdzhqlxzmc;

    /**构筑物类型*/
    private String gzwlx;

    /**单位*/
    private String mjdw;

    /**申请类型字典项*/
    private String sqlx;

    /**申请类型字名称*/
    private String sqlxmc;

    /**受理编号*/
    private String slbh;

    /** 土地证号*/
    private String tdzh;

    /**申请信息来源，1为微信，3为APP，2为web,4为其他*/
    private Integer sqxxly;

    /**区域代码*/
    private String qydm;

    /**区域代码*/
    private String qymc;

    private String dcxx;

    /**异议事项*/
    private String yysx;

    /**买卖合同编号*/
    private String mmhth;

    /**
     * 登记中心代码
     */
    private String djzx;
    /**
     * 登记中心代码
     */
    private String djzxmc;

    /**0是商品房买卖，1是存量房买卖*/
    private String gmspf;

    /**
     * 抵押银行代码
     */
    private String dyyhdm;

    /**
     * 是否抵押（0是，1否）
     */
    private String sfdy;

    /**
     * 是否抵押（0是，1否）
     */
    private String sfdylc;

    /**
     * 是否二次转移 1 是 0 否，默认否或空值
     */
    private String sfeczy;

    /**
     * 房产证号
     */
    private String fczh;

    /**
     * 建议预约时间
     */
    private String yysj;

    /**
     * 管理员审核人员gx_yy_user.USER_GUID
     */
    private String editUser;

    /**发送短信备注*/
    private String remark;

    /**是否邮寄（0是，1否）*/
    private String sfyj;

    /**邮寄地址*/
    private String yjdz;

    /**申请信息类型，sq：普通申请spwx：视频问询*/
    private String sqxxlx;

    /**坐落脱敏*/
    private String zlTm;

    /**是否查封*/
    private String sfcf;

    private String htqdrq;

    /**合同备案时间*/
    private String barq;

    /** 证书来源（2：新证书3：老证书）*/
    private String zsly;

    /**不动产单元编号*/
    private String bdcdybh;

    /**是否存在中介信息（0：是，1 ：否）*/
    private String sfczzjxx;

    /** 创建人所在部门*/
    private String createOrgId;

    /**是否是下属部门的件(0:否，1:是）*/
    private String isXsbm;

    /**权利人名称（冗余字段，名称以都好隔开）*/
    private String qlrmc;

    /**权利人证件号（冗余字段，以逗号隔开）*/
    private String qlrzjh;

    /**义务人名称（冗余字段，以逗号隔开）*/
    private String ywrmc;

    /**义务人证件号（冗余字段，以逗号隔开）*/
    private String ywrzjh;

    /**操作人所在部门*/
    private String updateOrgId;

    /**契税满两年 0 未满两年 1 满两年 放代码*/
    private String qsmln;

    /** 项目id*/
    private String xmid;

    /**房产证号list（分别持证时，以逗号隔开）*/
    private String fczhList;

    /**首付款（元）*/
    private String sfk;

    /**贷款金额（元）*/
    private String dkje;

    /**付款方式代码，字典项（元）*/
    private String fkfs;

    /**登记原因代码,字典项*/
    private String djyy;

    /**业务系统受理编号（业务系统返回值）*/
    private String ywxtslbh;

    /**预告证明*/
    private String ygzm;

    /**预告抵押证明*/
    private String ygdyzm;

    /**是否资金监管*/
    private String sfzjjg;

    /**税务状态（gx_yy_zd_type.ZD_TYPE=SWZT）*/
    private String swzt;

    /**税务审核信息*/
    private String swshxx;

    /**房源编号(税务)*/
    private String fybh;

    /**缴费状态（0:未缴费 1:部分缴费 2:已缴费）*/
    private String jfzt;

    /**预审通过时间*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date yytgsj;

    /**预审提示信息*/
    private String ystsxx;

    /**取得价格*/
    private String qdjg;

    /**抵押证明号*/
    private String dyzmh;

    /**子类型代码（gx_yy_zd_sqlx_zlx表zdm字段）*/
    private String zlxdm;

    /**业务号，用来存储合同信息接口返回的业务号*/
    private String ywh;

    /**导出次数*/
    private Integer exportcount;

    /**审核部门ID*/
    private String shOrgId;

    /**房产类型*/
    private String fclx;

    /**受理编号 字符反转字段（冗余字段，为了更友好的支持模糊查找）*/
    private String slbhReverse;

    /**登记时间（获取登记系统参数）*/
    private String djsj;

    /**购房发票号码*/
    private String gffphm;

    /**购房发票代码*/
    private String gffpdm;

    /**债务人*/
    private String zwr;

    /**抵押面积*/
    private String dymj;

    /**抵押面积其中土地*/
    private String dymjqztd;

    /**抵押物价值*/
    private String dywjz;

    /**被担保债权数额其中土地*/
    private String bdbzzqseqztd;

    /**抵押物价值其中土地*/
    private String dywjzqztd;

    /**最高债权确定事实*/
    private String zgzqqdss;

    /** 附记*/
    private String fj;

    /**roomid*/
    private String roomid;

    /**政务网受理编号保存数据库，以便后续使用*/
    private String zwwslbh;

    /**会签方式（0三方会签，1开发商待办）*/
    private String hqfs;

    /**税务部门预审orgid*/
    private String swOrgid;

    /**土地抵押面积*/
    private String tddymj;

    /**房屋抵押面积*/
    private String fwdymj;

    /**权证印刷序列号（印制号）*/
    private String qzysxlh;

    /**证书id*/
    private String zsid;

    /**是否移交推送登记系统（0：否，1：是）*/
    private String isYjts;

    /**是否办理遗失公告1:是，0：否*/
    private String sfblysgg;

    /**登记系统创建时间*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date djxtcjsj;

    /**交易ID（税务系统返回）*/
    private String jyid;

    /**云签状态(1：未签署，2：已签署或者免签署）*/
    private String yqzt;

    /**申请事由*/
    private String sqsy;

    /**退件原因*/
    private String tjyy;

    /**是否主房（0:否，1:是）*/
    private String sfzf;

    /**是否组合贷款(0否，1是)*/
    private String sfzhdk;

    /**上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)*/
    private String sbgjyczt;

    /**税费承担(字典项)*/
    private String sfcd;

    /**争议解决方式(字典项)*/
    private String zyjjfs;

    /**抵押贷款类别（字典项）*/
    private String dydklb;

    /**最高债权确定事实名称*/
    private String zgzqqdssmc;

    /**权利设定方式dm*/
    private String qlsdfs;

    /**被执行人信息查询描述*/
    private String bzxrxxcxms;

    /**查询结果说明*/
    private String cxjgsm;

    /**证书形式代码（1：纸质证2：电子证）*/
    private String zsxsdm;

    /**房屋ID(房屋编号,税务返回)*/
    private String fwuuid;

    /**权籍关联代码(字典项QJGL)*/
    private String qjgldm;

    /**使用期限*/
    private String syqx;

    /**产权来源*/
    private String cqly;

    /**登记接收人名称*/
    private String djjsrmc;

    /**登记接收人ID*/
    private String djjsrid;

    /**一卡清状态（YKQZT字典）*/
    private String ykqzt;

    /**申请按份共有的权利人处分方式（0:经占份额三分之二以上的共有人同意,1: 全体共同共有人同意,放代码）*/
    private String cffs;

    /**企业备案编号*/
    private String qybabh;

    /**缴费状态时间*/
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date jfztsj;

    /**申请书内容*/
    private String sqsnr;

    /**水电气过户id*/
    private String sdqghid;

    /**是否已领取纸质登记证明（0：否，1：是）*/
    private String sfylqzzdjzm;

    /**
     * 第三方服务收件时间（示例：2022-12-11 21:12:33），存的第三方的收件时间
     */
    private String dsffwsjsj;

    private String zssfyggzf;

    /**
     * 是否抵押注销（0：否，1：是）
     */
    private String sfdyzx;

    /**
     * 登记事由
     */
    private String djsy;
    /**创建接口返回proid*/
    private String proid;

    /**准销证号*/
    private String zxzh;

    /**ems自动推送状态（0:失败，1：成功）*/
    private String emstszt;

    /**解除原因*/
    private String jcyy;

    /**是否完全开发(0-否，1-是)*/
    private String sfwqkf;

    /**更正登记类型代码*/
    private String gzdjlxdm;

    /**更正主体*/
    private String gzzt;

    /**更正依据*/
    private String gzyj;

    /**更正内容*/
    private String gznr;

    /**申请材料提交方式*/
    private String sqcltjfs;

    /**项目子编号*/
    private String xmzbh;

    /**水电气操作人*/
    private String sdqczr;

    /**不处理原因*/
    private String bclyy;

    /**违约责任*/
    private String wyzr;

    /**监证机关*/
    private String jzjg;

    /**是否线上缴税*/
    private String sfxsjs;

    /**查询目的（gx_yy_zd_type字典表CXMD）*/
    private String cxmd;

    /**是否自动创建 1：是，0：否*/
    private String sfzdcj;

    /**是否银行直连1：是，0：否*/
    private String sfyhzl;

    /**申请单位唯一标识(代码)*/
    private String sqdwwybs;

    /**是否台账展示，1：是（单个、批量第一个），0：否 2转移 3抵押*/
    private String sftzzs;

    /**缴款方式 0：不交税费1：税费同缴*/
    private String jkfs;

    /**数据来源(1:微信 2:网页 3:APP)*/
    private String sjly;

    /**缴费方式（1:线上缴费 2:窗口缴费)*/
    private String jffs;

    /**是否税费托管（0否，1是)*/
    private String sfsftg;

    /**立案文书编号*/
    private String lawsbh;

    /**律师联系电话*/
    private String lslxdh;

    /**律师证号*/
    private String lszh;

    /**0未查询 1已查询 有结果 2已查询 无结果 3 查询异常*/
    private String cxzt;

    /**查询申请人类别（gx_yy_zd_type字典表CXSQRLB）*/
    private String cxsqrlb;

    /**查询目的手填*/
    private String cxmdst;

    /**是否需要登簿发证 （0：否，1：是）*/
    private String sfxydbfz;

    /**公告类型*/
    private String gglx;

    /**发布单位*/
    private String fbdw;

    /**登记证书形式代码（1：纸质证 2：电子证）*/
    private String djzsxsdm;

    /**预审地区代码*/
    private String ysdqdm;

    /**集成化办公登记回调标识*/
    private String djhdbs;

    /**集成化办公税务回调标识*/
    private String swhdbs;

    /**拆迁单位*/
    private String cqdw;

    /**是否推送预审 1：是，0：否*/
    private String sftsys;

    /**是否市县一体化流程（0：否，1：是）*/
    private String sfsxythlc;

    /**是否线下办理（1：是，0：否）*/
    private String sfxxbl;

    /**是否完成视频公证（1：是，0：否）*/
    private String sfwcspgz;

    /**是否已发送税费短信（1：是，0：否）*/
    private String sfyfssfdx;

    /**
     * 完税时间
     */
    private String wssj;
    /**
     * 核税时间
     */
    private String hssj;
    /**
     * 赠与合同约定条款
     */
    private String zyhtydtk;
    /**
     * 是否需要云签 0：否 1：是，（整个流程是否需要发起云签）
     */
    private String sfyq;
    /**
     * 智慧中枢受理编号
     */
    private String zhzsslbh;
    /**
     * 用章操作人id
     */
    private List<String> yzczrid;
    /**
     * 是否勾选我已承诺,1：是 0：否
     */
    private String sfgxwycn;
    /**
     * 是否预告 （0：是 1：否）
     */
    private String sfyg;
    /**
     * 权利人信息
     */
    private List<PushQlrxxDTO> qlrxxList;
    /**
     * 房屋信息
     */
    private PushFwxxDTO fwxx;
    /**
     * 土地信息
     */
    private PushTdxxDTO tdxx;
    /**
     * 抵押信息
     */
    private PushDyxxDTO dyxx;
    /**
     * 查封信息
     */
    private PushCfxxDTO cfxx;
    /**
     * 合同信息
     */
    private PushHtxxDTO htxx;
    /**
     * 资金监管
     */
    private PushZjjgDTO zjjg;
    /**
     * 申请信息扩展
     */
    private PushSqxxKzDTO sqxxkz;

    /**
     * 贷款方式名称
     */
    private String dkfsmc;

    /**
     * 服务类型
     */
    private String fuwlx;
    /**
     * 服务类型名称
     */
    private String fuwlxmc;

    /**
     * 原抵押金额
     */
    private String ydyje;

    /**
     * 是否提供现场服务
     */
    private String sftgxcfw;

    /**
     * 交付日期
     */
    private Date jfrq;

    /**
     * 竣工验收备案日期
     */
    private Date jgysbarq;
}
