package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (GxYyPj)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyPj implements Serializable {
    private static final long serialVersionUID = -1551225125331748477L;
    /**主键 */
    private String id;

    /**星级（5星：非常满意，4：满意，3：较满意，2：不满意，1：非常不满意）*/
    private String starLevel;

    /**评价内容*/
    private String evaluate;

    /**关联的受理编号*/
    private String slbh;

    /**关联的预约编号*/
    private String yybh;

    /**时间*/
    private Date createDate;

    /**评价者*/
    private String evaluator;

    /**满意度gx_yy_zd_spwxpj_myd.dm*/
    private String myd;

    /**节约路费gx_yy_zd_spwxpj_jylf.dm*/
    private String jylf;

    /**节约时间gx_yy_zd_spwxpj_jysj.dm*/
    private String jysj;

    /**推荐度gx_yy_zd_spwxpj_tjd.dm*/
    private String tjd;

    /**修改人*/
    private Date updateDate;

    /**修改评价者*/
    private String updateEvaluator;

    /**评价类型，0网上申请，1视频问询，3我的预约*/
    private String pjtype;

    /**满意度*/
    private String mydmc;

    /**节约路费*/
    private String jylfmc;

    /**节约时间*/
    private String jysjmc;

    /**推荐度*/
    private String tjdmc;

    /**江苏政务服务上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)*/
    private String jszwfwSbzt;

    /**江苏政务服务上报异常原因*/
    private String jszwfwMessage;
}

