package cn.gtmap.hlw.core.enums.sw;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/31
 * @description
 */
@Getter
@AllArgsConstructor
public enum WsbjEnum {
    /**
     * 已完税
     */
    YWS("Y", "已完税"),
    /**
     * 未完税
     */
    WWS("N", "未完税");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (WsbjEnum xq : WsbjEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
