package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyQlrJtcy;

import java.util.List;

/**
 * (GxYyQlrJtcy)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:49
 */
public interface GxYyQlrJtcyRepository {


    /**
     * 通过sqid查询数据
     *
     * @param sqid
     * @param qlrid
     * @param sfcxfcxx
     * @return 实例对象
     */
    List<GxYyQlrJtcy> getList(String sqid, String qlrid, String sfcxfcxx);

    /**
     * 通过ID查询单条数据
     *
     * @param jtcyid 主键
     * @return 实例对象
     */
    GxYyQlrJtcy get(Integer jtcyid);

    /**
     * 新增数据
     *
     * @param gxYyQlrJtcy 实例对象
     * @return 影响行数
     */
    void save(GxYyQlrJtcy gxYyQlrJtcy);

    /**
     * 修改数据
     *
     * @param gxYyQlrJtcy 实例对象
     * @return 影响行数
     */
    void update(GxYyQlrJtcy gxYyQlrJtcy);

    /**
     * 批量新增或修改数据
     *
     * @param jtcyList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyQlrJtcy> jtcyList);

    /**
     * 通过申请ID查询家庭成员信息集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYyQlrJtcy> list(String sqid);

    /**
     * 通过权利人ID查询家庭成员信息集合
     *
     * @param qlrid 权利人ID
     * @return 实例对象
     */
    List<GxYyQlrJtcy> getByQlrid(String qlrid);
    /**
     * 通过权利人ID查询家庭成员信息集合
     *
     * @param qlrid 权利人ID
     * @return 实例对象
     */
    List<GxYyQlrJtcy> getByQlridAndSfcxfcxx(String qlrid);

    /**
     * 通过ID删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Integer id);

    /**
     * 通过qlrid删除数据
     *
     * @param qlrid 权利人ID
     * @return 影响行数
     */
    int deleteByQlrid(String qlrid);

    /**
     * 通过qlrid删除数据
     *
     * @param qlrid 权利人ID
     * @param sqid
     * @return 影响行数
     */
    List<GxYyQlrJtcy> selectQlrJtgx(String qlrid, String sqid);

    /**
     * 通过qlridList查询数据
     *
     * @param qlridList 权利人ID集合
     * @return 影响行数
     */
    List<GxYyQlrJtcy> getListByQlrids(List<String> qlridList);

    /**
     * 通过qlrid删除数据
     *
     * @param qlrIdList 权利人ID
     * @return 影响行数
     */
    int deleteByQlrids(List<String> qlrIdList);

    /**
     * 通过sqid删除数据
     *
     * @param sqid 申请id
     * @return 影响行数
     */
    int deleteBySqid(String sqid);

    /**
     * 是否查询房产信息
     * @param qlridList
     * @param sfcxfcxx
     * @return
     */
    List<GxYyQlrJtcy> getListByQlridsAndSfcxfcxx(List<String> qlridList, String sfcxfcxx);

    /**
     * 查询家庭成员信息
     * @param qlrid
     * @return
     */
    List<GxYyQlrJtcy> getJtcyList(String qlrid);
    /**
     * 批量保存
     * @param jtcyList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyQlrJtcy> jtcyList);
}

