package cn.gtmap.hlw.core.dto.sign.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/7/5 09:38
 * @description 静默签章日志台账出参
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SilentLogByPageResultDTO {

    /**
     * 用章人
     */
    private String yzr;

    /**
     * 用章人所在企业
     */
    private String yzrszqy;

    /**
     * 用章时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date yzsj;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 申请类型
     */
    private String sqlx;

    /**
     * 盖章文件名称
     */
    private String wjmc;

    /**
     * 申请类型代码
     */
    private String sqlxdm;
}
