package cn.gtmap.hlw.core.dao.org;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.user.org.OrgListQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyOrg;

import java.util.List;

/**
 * (GxYyOrg)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyOrgDao {

    /**
     * 查询全部
     *
     * @return 实例对象
     */
    List<GxYyOrg> getAll();

    /**
     * @param orgIdList
     * @return List<GxYyOrgPO>
     * @description 查询
     * @version 2.0, 2024/2/19 14:45
     * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
     */
    List<GxYyOrg> getByOrgIdList(List<String> orgIdList);

    /**
     * 根据统一信用代码查询公司
     *
     * @param tyxydm 统一信用代码
     * @return 实例对象
     */
    GxYyOrg getByOrgName(String tyxydm);

    /**
     * 根据统一信用代码查询公司
     *
     * @param orgName 部门名称
     * @return 实例对象
     */
    GxYyOrg getByTyxydm(String orgName);

    /**
     * 通过ID查询单条数据
     *
     * @param orgId 主键
     * @return 实例对象
     */
    GxYyOrg get(String orgId);

    /**
     * 新增或修改
     *
     * @param gxYyOrgPO
     * @return String
     */
    String saveOrUpdateOrg(GxYyOrg gxYyOrgPO);

    /**
     * 接口实现 删除
     *
     * @param orgId 主键
     * @return 删除的条数
     */
    void delete(String orgId);

    /**
     * 分页查询
     *
     * @param orgListQueryParamsDTO
     * @return GxYyMenuPO集合
     */
    PageInfo<GxYyOrg> queryPage(OrgListQueryParamsDTO orgListQueryParamsDTO);
}

