package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyUserRoleRel;

import java.util.List;

/**
 * (GxYyUserRoleRel)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
public interface GxYyUserRoleRelRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param userRoleRelId 主键
     * @return 实例对象
     */
    GxYyUserRoleRel get(String userRoleRelId);

    /**
     * 新增数据
     *
     * @param gxYyUserRoleRel 实例对象
     * @return 影响行数
     */
    void save(GxYyUserRoleRel gxYyUserRoleRel);

    void saveOrUpdateBatchUR(List<GxYyUserRoleRel> userRoleList);

    /**
     * 修改数据
     *
     * @param gxYyUserRoleRel 实例对象
     * @return 影响行数
     */
    void update(GxYyUserRoleRel gxYyUserRoleRel);

    /**
     * 获取数据
     *
     * @param userId 用户id
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getGxYyUserRoleRelsByUserId(String userId);

    List<GxYyUserRoleRel> getByuserIdList(List<String> userIdList);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getAll();

    /**
     * 删除数据
     *
     * @param userRoleRelId
     * @return 影响行数
     */
    int delete(String userRoleRelId);

    void deleteByUserId(String userId);

    void deleteOrgRoleByUserId(String userId);

    /**
     * 获取数据
     *
     * @param userIdList 用户id
     * @param roleId 角色id
     * @return 影响行数
     */
    List<GxYyUserRoleRel> getByuserIdListAndRoleId(List<String> userIdList, String roleId);
}

