package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.JkglPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyJkgl;

import java.util.List;

/**
 * 接口管理表(GxYyJkgl)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyJkglRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyJkgl get(String id);

    /**
     * 新增数据
     *
     * @param gxYyJkgl 实例对象
     * @return 影响行数
     */
    String save(GxYyJkgl gxYyJkgl);

    /**
     * 修改数据
     *
     * @param gxYyJkgl 实例对象
     * @return 影响行数
     */
    String update(GxYyJkgl gxYyJkgl);

    /**
     * 根据行政区域代码和接口关键字去查询接口管理表
     *
     * @param xzqydm
     * @param jkgjz
     * @return
     */
    GxYyJkgl query(String xzqydm, String jkgjz);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return PageInfo<GxYyJkgl>
     */

    PageInfo<GxYyJkgl> queryPage(JkglPageParamsDTO paramsDTO);

    /**
     * 删除数据
     *
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);

    /**
     * 查询接口管理全部数据
     *
     * @return GxYyJkgl集合
     */
    List<GxYyJkgl> getAll();

    /**
     * 保存更新
     *
     * @param gxYyJkgl 接口管理
     */
    void saveOrUpdate(GxYyJkgl gxYyJkgl);

}

