package cn.gtmap.hlw.core.util.ahwstface;

/**
 * 统一错误状态码
 */
public enum AhWstFaceErrorMsg {
    SYSTEM_ERROR("00000", "系统异常，请稍后重试"),
    SUCCESS("20000", "请求成功"),
    NO_PARAMETER("20001", "必填参数不可为空"),
    AUTH_CODE_ERROR("20002", "authCode授权接口请求异常"),
    RESPONSE_ILEGAL_ERROR("20003", "authCode授权接口返回值被篡改"),
    FVTOKEN_ERROR("20004", "fvtoken接口请求异常");

    private String code;
    private String name;

    AhWstFaceErrorMsg(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


}
