package cn.gtmap.hlw.core.enums.sqlx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 交易合同类型
 *
 * @author <a href="mailto:chengong@gtmap.cn">chengong</a>
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
@Getter
@AllArgsConstructor
public enum JyhtlxEnum {

    /**
     * 交易合同类型 - 存量房合同
     */
    JYHTLX_SHC("shc", "存量房合同", "htxxEvent"),

    /**
     * 交易合同类型-  现房商品房合同
     */
    JYHTLX_CHPC("chpc", "现房商品房合同", ""),

    /**
     * 交易合同类型-  预告，期房商品房合同
     */
    JYHTLX_CHPY("chpy", "预告，期房商品房合同", ""),

    /**
     * 商品房合同
     */
    JYHTLX_SPF("spf", "商品房合同", "spfHtxxEvent"),
    /**
     * 商品房合同
     */
    JYHTLX_CLF("clf", "存量房合同", "htxxEvent");

    private String code;

    private String msg;

    private String jksxl;

    public static String getJksxl(String code) {
        for (JyhtlxEnum xq : JyhtlxEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getJksxl();
            }
        }
        return null;
    }
}
