package cn.gtmap.hlw.core.dao.xtjr;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.xtjr.XtjrPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyXtjr;

import java.util.List;

/**
 * 系统接入表(GxYyXtjr)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyXtjrDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyXtjr get(String id);
    /**
     * 通过ID查询单条数据
     *
     * @param xtdm 系统代码
     * @param xzqydm 行政区域代码
     * @return 实例对象
     */
    GxYyXtjr getByXtdmAndXzqydm(String xtdm,String xzqydm);

    /**
     * 查询系统接入表全部数据
     * @return 实例对象集合
     */
    List<GxYyXtjr> getAll();


    /**
     * 获取接入系统信息
     *
     * @param xzqydm
     * @param xtdm
     * @return
     */
    GxYyXtjr query(String xzqydm, String xtdm);

    /**
     * 系统接入表--分页查询
     * @param paramsDTO
     * @return GxYyXtjrPO集合
     */
    PageInfo<GxYyXtjr> queryPage(XtjrPageParamsDTO paramsDTO);

    /**
     * 根据主键删除数据
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);

    /**
     * 保存更新
     * @param gxYyXtjr
     */
    void saveOrUpdateXtjr(GxYyXtjr gxYyXtjr);
    /**
     * 根据sjly查询数据
     * @param sjlyList
     * @return
     */
    List<GxYyXtjr> getBysjlyList(List<String> sjlyList);


}

