package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.onething.OneThingParamsDTO;
import cn.gtmap.hlw.core.dto.sqxx.tz.*;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.query.sqxx.ByztQuery;
import cn.gtmap.hlw.core.model.query.sqxx.GxYySqxxQuery;
import cn.gtmap.hlw.core.model.query.sqxx.GxYyYjdQuery;
import cn.gtmap.hlw.core.model.query.sqxx.YhrlQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 不动产申请信息表(GxYySqxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYySqxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYySqxx get(String sqid);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYySqxx> list(String slbh);

    /**
     * 通过slbhList查询集合数据
     *
     * @param slbhList
     * @return 实例对象
     */
    List<GxYySqxx> list(List<String> slbhList);

    /**
     * 通过sqid查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxx> listBySqid(List<String> sqidList);

    /**
     * 新增数据
     *
     * @param gxYySqxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxx gxYySqxx);

    /**
     * 修改数据
     *
     * @param gxYySqxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxx gxYySqxx);

    /**
     * 修改数据
     *
     * @param slzt
     * @param slxx
     * @param sqid
     * @return 影响行数
     */
    void updateBySlztAndSlxx(String sqid, String slzt, String slxx);

    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    int delete(String slbh);

    /**
     * 批量删除数据
     *
     * @param sqidList 申请id集合
     * @return 影响行数
     */
    int deleteBatchIds(List<String> sqidList);

    /**
     * 保存或修改数据
     *
     * @param gxYySqxx 实例对象
     * @return
     */
    void saveOrUpdate(GxYySqxx gxYySqxx);

    /**
     * 批量保存或修改数据
     *
     * @param gxYySqxxList 实例对象
     * @return
     */
    void saveOrUpdateBatch(List<GxYySqxx> gxYySqxxList);

    /**
     * 分页查询
     *
     * @param slbh
     * @param sfdy
     * @return
     */
    //GxYySqxx getSqxxZyBySlbh(String slbh, String sfdy);

    /**
     * 查询申请信息
     *
     * @param paramMap
     * @return:List<GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> getListByMap(Map paramMap);

    /**
     * 查询申请信息
     *
     * @param gxYySqxxQuery
     * @return:List<GxYySqxx>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYySqxx> getGxYySqxxList(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 通过不动产单元集合查询申请信息
     *
     * @param bdcdyhList 不动产单元集合
     * @return:List<GxYySqxx>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYySqxx> getGxYySqxxByBdcdyhList(List<String> bdcdyhList);

    /**
     * 查询申请信息
     *
     * @param sqlxList
     * @param range
     * @return:List<GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<String> getConditionListBySqlxList(Set<String> sqlxList, String range);

    /**
     * 根据slbh查询转移申请信息集合
     *
     * @param slbh
     * @return:GxYySqxx
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    List<GxYySqxx> getSqxxListZyBySlbh(String slbh);

    /**
     * 根据slbh查询转移sqxx
     *
     * @param slbh
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxx getSqxxZyBySlbh(String slbh);

    /**
     * 根据sqxxList查询转移sqxx (考虑到批量流程，存在批量转移的情况，不能只返回一条。)
     *
     * @param sqxxList
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> getSqxxZyBySqxxList(List<GxYySqxx> sqxxList);

    /**
     * 根据slbh查询抵押sqxx
     *
     * @param slbh
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> getSqxxDyBySlbh(String slbh);

    /**
     * 根据slbh查询抵押注销sqxx
     *
     * @param slbh
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxx getSqxxDyzxBySlbh(String slbh);

    /**
     * 中介分页查询
     *
     * @param gxYySqxxQuery
     * @return:IPage
     */
    IPage<GxYySqxx> getPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 统计
     *
     * @param gxYySqxxQuery
     * @return:IPage
     */
    int getCount(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 个人分页查询
     *
     * @param gxYySqxxQuery
     * @return:IPage
     */
    IPage<SqxxTzResultDTO> getGrPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 更新fwuuid
     *
     * @param gxYySqxx
     * @return:IPage
     */
    void updateFwuuidAndJyid(GxYySqxx gxYySqxx);

    /**
     * 更新申请信息
     *
     * @param gxYySqxx
     */
    void updateSqxx(GxYySqxx gxYySqxx);

    /**
     * 根据slbh更新税务状态
     *
     * @param slbh 受理编号
     * @param swzt 税务状态
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void updateSwzt(String slbh, String swzt);

    void updateSwzt(String slbh, String swzt, String swshxx);

    void updateSlxx(String slbh, String slxx);

    /**
     * 根据slbh获取单个sqxx
     *
     * @param slbh
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxx getSqxxOneBySlbh(String slbh);

    /**
     * 根据YwxtSlbh获取单个sqxx
     *
     * @param ywxtslbh
     * @return:GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxx getSqxxOneByYwxtSlbh(String ywxtslbh);

    /**
     * 更新缴费状态
     *
     * @param slbh
     * @param jfzt
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void updateJfzt(String slbh, String jfzt);

    /**
     * 更新受理状态
     *
     * @param slbh
     * @param slzt
     * @return:void
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    void updateSlzt(String slbh, String slzt);

    /**
     * 更新导出状态
     *
     * @param slbhList
     */
    void updateDczt(List<String> slbhList);

    /**
     * 获取抵押申请信息
     *
     * @param sqxxList
     * @return
     */
    List<GxYySqxx> getSqxxDyBySqxxList(List<GxYySqxx> sqxxList);

    /**
     * 根据sqid删除
     *
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteById(String sqid);

    /**
     * 查询申请信息
     *
     * @param gxYySqxxQuery
     * @return:List<GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> querySqxxList(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 登记机构预审分页查询
     *
     * @param gxYySqxxQuery
     * @return:IPage<GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYySqxx> getPreliminaryPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 个人-我的核验
     *
     * @param gxYySqxxQuery
     * @return
     */
    IPage<SqxxTzResultDTO> selectMyPersonalHyListByPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 银行-我的核验
     *
     * @param gxYySqxxQuery
     * @return
     */
    IPage<SqxxTzResultDTO> selectMyBankHyListByPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 分页查询sqxx表
     *
     * @param gxYySqxxQuery
     * @return
     */
    IPage<GxYySqxx> getSqxxPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 银行预审分页查询
     *
     * @param gxYySqxxQuery
     * @return:IPage<GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYySqxx> getYhysPage(GxYySqxxQuery gxYySqxxQuery);

    IPage<GxYySqxx> getBankApplyList(BankApplyQueryDTO queryDTO);

    /**
     * 更新审核时间
     *
     * @param date
     * @param slbh
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void updateEditDate(Date date, String slbh);

    /**
     * 办件数量统计台账
     *
     * @param gxYySqxxQuery
     * @return:ReturnResult<PageInfo<SqxxTzResultDTO>>
     */
    List<Map<String, Object>> countBj(GxYySqxxQuery gxYySqxxQuery);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 查询银行未签章信息
     */
    List<GxYySqxx> queryYhWqzSqxx(GxYySqxxQuery gxYySqxxQuery);

    /**
     * @param
     * @return
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 统计个人抵押工作量统计
     */
    IPage<SqxxTzDyGzlCountResultDTO> countDyGzl(GxYySqxxQuery gxYySqxxQuery);

    /**
     * @param
     * @return
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 根据创建日期统计我的申请数量
     */
    Integer getSqxxNumByCreateDate(Date kssj, Date jssj, String userId);

    /**
     * @param
     * @return
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 根据创建日期统计我的核验数量
     */
    Integer getHyxxNumByCreateDate(ByztQuery byztQuery);

    /**
     * 一件事办件分页查询
     *
     * @param paramsDTO
     * @return:com.baomidou.mybatisplus.core.metadata.IPage<java.util.List<java.lang.String>>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<String> getYjsBjPage(OneThingParamsDTO paramsDTO);

    /**
     * 一件事未申报--非组合流程
     *
     * @param paramsDTO
     * @return:java.util.List<java.util.Map>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<Map> queryYjsbjNotZh(OneThingParamsDTO paramsDTO);

    /**
     * 一件事未申报 -- 组合流程
     *
     * @return:java.util.List<java.util.Map>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<Map> queryYjsbjZh(OneThingParamsDTO paramsDTO);

    /**
     * 批量插入
     *
     * @param sqxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYySqxx> sqxxList);

    /**
     * 批量更新
     *
     * @param gxYySqxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void updateBatch(List<GxYySqxx> gxYySqxxList);

    /**
     * 根据合同号查询
     *
     * @param mmhth
     * @return:cn.gtmap.hlw.domain.sqxx.model.GxYySqxx
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYySqxx getByMmhth(String mmhth);

    /**
     * 落宗申请台账
     */
    IPage<GxYySqxx> getSqxxLzsq(GxYySqxxQuery gxYySqxxQuery);

    /**
     * 根据权利人证件号查询
     *
     * @param jtcyzjh
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> queryByQlrzjh(String jtcyzjh);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 获取申请信息左模糊
     */
    List<GxYySqxx> querySqxxBySlbLikeLeft(String slbh);

    /**
     * 根据bdcdyh查询
     *
     * @param bdcdyh
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxx> listByBdcdyh(String bdcdyh);

    /**
     * 银行登记费台账
     *
     * @param gxYySqxxQuery
     * @return:com.baomidou.mybatisplus.core.metadata.IPage<cn.gtmap.hlw.core.dto.sqxx.tz.DjfTzResultDTO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<DjfTzResultDTO> getYhDjfPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 根据受理编号查询申请信息抵押注销集合
     */
    List<GxYySqxx> getSqxxDyzxListBySlbh(String slbh);

    /**
     * 移交单生成查询
     *
     * @param gxYyYjdQuery
     * @return: YjdscResultDTO
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    IPage<YjdscResultDTO> getYjdscPage(GxYyYjdQuery gxYyYjdQuery);


    /**
     * 移交单管理查询
     *
     * @param gxYyYjdQuery
     * @return: YjdscResultDTO
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    IPage<YjdglResultDTO> getYjdglPage(GxYyYjdQuery gxYyYjdQuery);

    /**
     * @param
     * @return
     * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
     * @description 查询登记费分页
     */
    IPage<DjfTzResultDTO> getDjfPage(GxYySqxxQuery gxYySqxxQuery);

    /**
     * @param yhrlQuery
     * @return IPage<YhrlResultDTO>
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     * @description 查询银行认领分页
     */
    IPage<YhrlQueryResultDTO> getSqxxYhrlPage(YhrlQuery yhrlQuery);

    /**
     * 查询预告分页
     * @param gxYySqxxQuery
     * @return:com.baomidou.mybatisplus.core.metadata.IPage<cn.gtmap.hlw.core.model.GxYySqxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    IPage<GxYySqxx> getYgPage(GxYySqxxQuery gxYySqxxQuery);
}

