package cn.gtmap.hlw.core.enums.error;


import cn.gtmap.hlw.core.exception.IError;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 通用异常 ： 以下枚举根据实际业务进行调整
 */
@AllArgsConstructor
public enum ErrorEnum implements IError {
    /**
     * 成功
     */
    SUCCESS("0000", "success"),

    /**
     * 失败
     */
    FAIL("0001", "fail"),

    /**
     * 新增异常
     */
    ADD_ERROR("2001", "新增异常"),

    /**
     * 修改异常
     */
    UPDATE_ERROR("2002", "修改异常"),

    /**
     * 删除异常
     */
    DELETE_INVALID("2003", "删除异常"),

    /**
     * 查询异常
     */
    NOT_FOUND("2004", "查询异常"),

    /**
     * 新增或修改异常
     */
    ADD_UPDATE_ERROR("2005", "新增或修改异常"),

    /**
     * 问询笔录勾选答案错误
     */
    VALIDATION_FAIL("2006", "问询笔录勾选答案错误"),

    /**
     * 代码未知错误
     */
    INTERNAL_SERVER_ERROR("3001", "代码未知错误"),

    /**
     * 非法入参
     **/
    ILLEGAL_ARGUMENT("3002", "非法入参"),

    PARAM_NULL("3003", "入参为空"),

    /**
     * 方法不支持
     **/
    METHOD_NOT_ALLOWED_ERROR("3004", "方法不支持"),

    /**
     * 数据初始化失败
     */
    DATA_INIT_FAIL("3005", "数据初始失败"),

    /**
     * 附件不能为空
     */
    FJ_PARAM_NULL("3006", "附件不能为空"),
    /**
     * 用户无权操作该流程附件
     */
    USER_NO_AUTH_FJ("3007", "用户无权操作该流程附件"),

    USER_NO_AUTH("3008", "用户无权操作该流程"),
    /**
     * 验证失败
     */
    CHECK_FAIL("3009", "验证失败"),
    /**
     * 缺少配置项
     */
    PZX_NOT_EXISTS("3010", "缺少配置项"),

    /**
     * 数据库没数据
     */
    NO_DATA("3011", "数据库没数据"),
    /**
     * 票据超时
     */
    TICKET_TIMEOUT("3012", "票据超时"),
    /**
     * 领域事件异常
     */
    LYSJ_ERR("3013", "领域事件异常"),
    /**
     * 领域事件动作缺失异常
     */
    LYSJ_LYDZ_EMPTY_ERR("3019", "领域事件动作缺失异常"),
    /**
     * 流程打印
     */
    LCDY_NODATA("3014", "数据库没有对应的流程打印"),
    /**
     * 角色非法，无查询权限
     */
    ILLEGAL_ROLE("3015", "角色非法，无查询权限"),
    /**
     * 消息发送错误
     */
    MESSAGE_ERROR("3016", "消息发送错误"),
    /**
     * 消息发送错误
     */
    USERNAME_PWD_ERROR("3017", "用户名或者密码错误"),
    /**
     * 非法的附件类型
     */
    ILLEGAL_FILETYPE("3018", "非法的附件类型"),

    /**
     * 请求未授权
     */
    UN_AUTHORIZED("6666","请求未授权"),
    /**
     * 附件文件不存在 状态码
     */
    FJ_FILE_NOTEXISTS("5001", "附件文件不存在"),
    /**
     * 通用异常
     **/
    SERVICE_ERROR("500", "服务器异常"),
    /**
     * 第三方服务异常
     */
    THIRD_SERVICE_ERROR("5002","第三方服务异常"),
    /**
     * 未查询到数据
     */
    THIRD_SERVICE_NOT_FOUND_ERROR("5003","未查询到数据"),
    /**
     * 操作太过平凡，请稍后在试！
     */
    TOO_FREQUENT_VISIT("5004","操作太过频繁，请稍后在试！");
    @Getter
    private String code;

    @Getter
    private String msg;

}
