package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 证件类型
 *ZjlxEnum
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum ZjlxEnum {

    /**
     * 证件类型-身份证
     */
    SFZJZL_SFZ("1", "身份证"),

    /**
     * 证件类型-港澳身份证
     */
    SFZJZL_GASFZ("2", "港澳身份证"),

    /**
     * 证件类型-护照
     */
    SFZJZL_HZ("3", "护照"),

    /**
     * 证件类型-户口簿
     */
    SFZJZL_HKB("4", "户口簿"),

    /**
     * 证件类型-军官证
     */
    SFZJZL_JGZ("5", "军官证"),

    /**
     * 证件类型-组织机构代码
     */
    SFZJZL_ZHJGDM("6", "组织机构代码"),

    /**
     * 证件类型-营业执照
     */
    SFZJZL_YYZZ("7", "营业执照"),

    /**
     * 证件类型-统一信用代码
     */
    SFZJZL_TYSHXYDM("8", "统一信用代码"),
    /**
     * 证件类型-外国人永久居留证
     */
    SFZJZL_WGRYJJLZ("9", "外国人永久居留证"),

    /**
     * 证件类型-来大陆通行证
     */
    SFZJZL_DLTXZ("92", "来大陆通行证"),
    /**
     * 证件类型-港澳居民居住证
     */
    SFZJZL_GAJMJZZ("95", "港澳居民居住证"),

    /**
     * 证件类型-香港永久性居民身份证
     */
    SFZJZL_XGYJXJMSFZ("219", "香港永久性居民身份证"),
    /**
     * 证件类型-台湾身份证
     */
    SFZJZL_TWTBZ("220", "台湾身份证"),
    /**
     * 证件类型-澳门特别行政区永久性居民身份证
     */
    SFZJZL_AMYJXJMSFZ("221", "澳门特别行政区永久性居民身份证"),

    /**
     * 证件类型-其他
     */
    SFZJZL_QT ("99", "其他");


    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (ZjlxEnum xq : ZjlxEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

    public static String getCode(String msg) {
        for (ZjlxEnum xq : ZjlxEnum.values()) {
            if (xq.msg.equals(msg)) {
                return xq.getCode();
            }
        }
        return null;
    }
    
}
