package cn.gtmap.hlw.core.dto.dypz;


import cn.gtmap.hlw.core.dto.workflow.export.LcdyPzDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyDysjPz;
import cn.gtmap.hlw.core.model.GxYyDysjZbPz;
import cn.gtmap.hlw.core.util.string.StringUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2024/5/30
 * @description 打印配置接口交互类
 */
@Data
public class DysjPzDTO extends GxYyDysjPz {
    /**
     * 顺序号
     */
    private String sxh;

    List<GxYyDysjZbPz> gxYyDysjZbPzList;

    /**
     * 打印参数
     */
    List<Map<String, Object>> dycsMapList;

    /**
     * 云签打印配置
     */
    List<LcdyPzDTO> gxYyLcdyList;


    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 解密执行SQL
     */
    public void decodeBase64() throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank(super.getDysjy())) {
            super.setDysjy(URLDecoder.decode(new String(Base64.getDecoder().decode(super.getDysjy()),"UTF-8")));
            this.getGxYyDysjZbPzList().stream().forEach(po -> {
                if (StringUtils.isNotBlank(po.getDyzbsjy())) {
                    try {
                        po.setDyzbsjy(URLDecoder.decode(new String(Base64.getDecoder().decode(po.getDyzbsjy()),"UTF-8")));
                    } catch (UnsupportedEncodingException e) {
                        throw new BizException(ErrorEnum.ILLEGAL_ARGUMENT.getCode(), "解密失败！");
                    }
                }
            });
        }
    }

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 加密执行SQL
     */
    public void encodeBase64() {
        if (StringUtils.isNotBlank(super.getDysjy())) {
            super.setDysjy(StringUtil.encodeBase64(URLEncoder.encode(super.getDysjy()).replace("+", "%20")));
            this.getGxYyDysjZbPzList().stream().forEach(po -> {
                if (StringUtils.isNotBlank(po.getDyzbsjy())) {
                    po.setDyzbsjy(StringUtil.encodeBase64(URLEncoder.encode(po.getDyzbsjy()).replace("+", "%20")));
                }
            });
        }
    }
}
