package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.node.INode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


/**
 * 专题服务表(GxYyZtfw)表实体类BO
 *
 * @author makejava
 * @since 2023-06-12 13:34:11
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyZtfw implements INode<GxYyZtfw> {
    private static final long serialVersionUID = -1511186282927351862L;
    /**
     * id
     */
    private String id;

    /**
     * 专题服务名称
     */
    private String ztfwmc;

    /**
     * 角色代码（gx_yy_zd_role.dm）
     */
    private String role;

    /**
     * 顺序号
     */
    private Integer sxh;

    /**
     * 主题图标
     */
    private String zttb;

    /**
     * 父专题服务id
     */
    private String parentId;

    /**
     * 子孙节点
     */
    private List<GxYyZtfw> children;

    @Override
    public List<GxYyZtfw> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        return this.children;
    }

}

