/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.rsa2;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class Rsa2SignUtil {
    private static final String SIGN_ALGORITHMS = "SHA256WithRSA";
    private static final String CHARSET = "utf-8";

    public static String signByRSA(Map<String, Object> params, String privateKey) {
        try {
            String content = Rsa2SignUtil.createLinkString(Rsa2SignUtil.paramsFilter(params));
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(CHARSET));
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean verifyByRSA(Map<String, Object> params, String sign, String publicKey) {
        try {
            String content = Rsa2SignUtil.createLinkString(Rsa2SignUtil.paramsFilter(params));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = Base64.decodeBase64((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(CHARSET));
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Map<String, String> paramsFilter(Map<String, Object> params) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (params == null || params.size() == 0) {
            return result;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null || "sign".equals(entry.getKey())) continue;
            result.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return result;
    }

    private static String createLinkString(Map<String, String> params) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (value == null || "".equals(value) || "sign".equals(key)) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    public static String signByRSA(String content, String privateKey) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(CHARSET));
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

