package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxProcess;

import java.util.List;

/**
 * (GxYyProcess)表数据库访问层
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-24 19:51
 */
public interface GxYySqxxProcessRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param processId 主键
     * @return 实例对象
     */
    GxYySqxxProcess get(String processId);

    /**
     * 新增数据
     *
     * @param gxYySqxxProcess 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxProcess gxYySqxxProcess);

    /**
     * 修改数据
     *
     * @param gxYySqxxProcess 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxProcess gxYySqxxProcess);
    /**
     * 修改数据
     *
     * @param slbh
     * @param processId
     * @return 影响行数
     */
    void updateSfycToByc(String slbh,String processId);
    /**
     * 修改数据
     *
     * @param slbh
     * @param processId
     * @return 影响行数
     */
    void updateSfycToYc(String slbh,String processId);

    /**
     * 通过slbh, clientType查询单条数据
     *
     * @param slbh 受理编号
     * @param type 类型
     * @param type
     * @return 实例对象
     */
    List<GxYySqxxProcess> get(String slbh, String type);

    /**
     * 批量更新或插入数据
     *
     * @param gxYySqxxProcessList 实例对象
     */
    void saveOrUpdateBatch(List<GxYySqxxProcess> gxYySqxxProcessList);
    /**
     * 修改数据
     *
     * @param slbh
     * @param processId
     * @return 影响行数
     */
    void updateBySlbhAndProcessId(String slbh,String processId);

    void updateBySlbhAndProcessIdList(String slbh, List<String> processIdList);

    /**
     * 批量插入数据
     *
     * @param gxYySqxxProcessList 实例对象
     */
    void saveBatch(List<GxYySqxxProcess> gxYySqxxProcessList);
}

