package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFwxx;
import cn.gtmap.hlw.core.model.query.fwxx.GxYyFwxxQuery;
import com.baomidou.mybatisplus.core.metadata.IPage;

import java.util.List;

/**
 * 在线申请--房屋信息(GxYyFwxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:49
 */
public interface GxYyFwxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param sqid 主键
     * @return 实例对象
     */
    GxYyFwxx get(String sqid);
    /**
     * 通过ID查询单条数据
     *
     * @param slbh 主键
     * @return 实例对象
     */
    GxYyFwxx getBySlbh(String slbh);

    /**
     * 新增数据
     *
     * @param gxYyFwxx 实例对象
     * @return 影响行数
     */
    void save(GxYyFwxx gxYyFwxx);

    /**
     * 修改数据
     *
     * @param gxYyFwxx 实例对象
     * @return 影响行数
     */
    void update(GxYyFwxx gxYyFwxx);

    /**
     * 保存或修改数据
     *
     * @param gxYyFwxx 实例对象
     * @return
     */
    void saveOrUpdate(GxYyFwxx gxYyFwxx);

    /**
     * 删除数据
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    int delete(String slbh);

    /**
     * 通过sqidList查询单条数据
     *
     * @param sqidList 主键
     * @return 实例对象
     */
    List<GxYyFwxx> list(List<String> sqidList);
    /**
     * 批量保存
     * @param fwxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void saveOrUpdateBatch(List<GxYyFwxx> fwxxList);
    /**
     * 根据sqid删除
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    void deleteById(String sqid);
    /**
     * 分页查询
     * @param gxYyFwxxQuery
     * @return:IPage<GxYyFwxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    IPage<GxYyFwxx> getPage(GxYyFwxxQuery gxYyFwxxQuery);

    /**
     * 根据受理编号查询
     * @param slbh
     * @return:List<GxYyFwxx>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyFwxx> listBySlbh(String slbh);
    /**
     * 批量插入
     * @param fwxxList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void insertBatch(List<GxYyFwxx> fwxxList);
}

