package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 认证状态
 */
@Getter
@AllArgsConstructor
public enum SfrzEnum {
    /**
     * 认证通过
     */
    SFRZ_RZTG(0, "认证通过"),
    /**
     * 未认证
     */
    SFRZ_WRZ(1, "未认证"),
    /**
     * 驳回
     */
    SFRZ_BH(2, "驳回"),
    /**
     * 待认证-银行认证通过后个人核验
     */
    SFRZ_DRZ_YH(3, "待认证-银行认证通过后个人核验"),
    /**
     * 待认证-个人核验后银行核验
     */
    DRZ_GR(4, "待认证-个人核验后银行核验");

    @Getter
    private Integer code;

    @Getter
    private String msg;

    /**
     * 获取编码对应的消息
     */
    public static String getMsgByCode(Integer code) {
        for (SfrzEnum sfrzEnum : SfrzEnum.values()) {
            if (sfrzEnum.getCode().equals(code)) {
                return sfrzEnum.getMsg();
            }
        }
        return null;
    }

}
