package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 家庭关系
 */
@Getter
@AllArgsConstructor
public enum JtgxEnum {

    /**
     * 户主
     */
    JTGX_HZ("0", "户主"),
    /**
     * 父亲
     */
    JTGX_FQ("1", "父亲"),
    /**
     * 母亲
     */
    JTGX_MQ("2", "母亲"),
    /**
     * 配偶
     */
    JTGX_PO("3", "配偶"),
    /**
     * 配偶
     */
    JTGX_CNZN("4", "成年子女"),
    /**
     * 未成年子女
     */
    JTGX_WCNZN("5", "未成年子女"),
    /**
     * 兄弟
     */
    JTGX_XD("6", "兄弟"),
    /**
     * 姐妹
     */
    JTGX_JM("7", "姐妹"),
    /**
     * 本人
     */
    JTGX_BR("8", "本人"),
    /**
     * 祖父
     */
    JTGX_ZF("9", "祖父"),
    /**
     * 祖母
     */
    JTGX_ZM("10", "祖母"),
    /**
     * 删除字段，如果现场不想展示某些家庭关系，直接对照成该字段，查询结果会被删除
     */
    JTGX_REMOVE("999", "无效关系");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (JtgxEnum xq : JtgxEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
