package cn.gtmap.hlw.core.dao.dict;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.pzx.HlwPzxQueryDTO;
import cn.gtmap.hlw.core.model.HlwPzPzx;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/11/30 10:24
 * @description HlwPzPzxDao
 */
public interface HlwPzPzxDao {
    /**
     * 查询所有配置项
     *
     * @return 集合
     */
    List<HlwPzPzx> all();

    /**
     * 通过ID查询单条数据
     *
     * @param pzxKey
     * @return 实例对象
     */
    HlwPzPzx getHlwPzPzxByPzxKey(String pzxKey);

    /**
     * 通过ID查询单条数据
     *
     * @param pzxKey
     * @return 实例对象
     */
    String getHlwPzPzxValueByPzxKey(String pzxKey);

    /**
     * 根据pzx_key查询
     * todo:驼峰
     * @param pzxKeylist
     * @return:List<HlwPzPzxPO>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<HlwPzPzx> ListByPzxKey(List<String> pzxKeylist);

    /**
     * 通过ID查询单条数据
     *
     * @param pzxid 主键
     * @return 实例对象
     */
    HlwPzPzx get(String pzxid);

    /**
     * 删除
     *
     * @param pzxid 主键
     * @return 实例对象
     */
    void delete(String pzxid);

    /**
     * 修改
     */
    void updatePzxzt();

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<HlwPzPzx> page(HlwPzxQueryDTO queryDTO);
    /**
     * 批量保存或更新
     *
     * @param pzPzxPoList
     * @return
     */
    void saveOrUpdateBatchA(List<HlwPzPzx> pzPzxPoList);
    /**
     * 保存或更新
     *
     * @param hlwPzPzx
     * @return
     */
    void saveOrUpdate(HlwPzPzx hlwPzPzx);
}
