/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import cn.gtmap.estateplat.register.common.util.PublicUtil;
import cn.gtmap.hlw.core.dto.ftp.FtpDeleteParamDTO;
import cn.gtmap.hlw.core.dto.ftp.FtpDownloadParamDTO;
import cn.gtmap.hlw.core.dto.ftp.FtpInitParamDTO;
import cn.gtmap.hlw.core.dto.ftp.FtpUploadParamDTO;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtils.class);
    private static String LOCAL_CHARSET = "GBK";
    private static String SERVER_CHARSET = "ISO-8859-1";
    private static final String FILE_CENTER = "/fileCenter";
    private static FTPClient ftpClient = null;

    private static void initFtpClient(FtpInitParamDTO paramDTO) {
        ftpClient = new FTPClient();
        logger.info("initFtpClient.paramDTO:{}", (Object)JSONObject.toJSONString((Object)paramDTO));
        String encoding = paramDTO.getServerEncoding();
        String hostname = paramDTO.getServerHost();
        String port = paramDTO.getServerPort();
        String username = paramDTO.getServerUsername();
        String password = paramDTO.getServerPassword();
        ftpClient.setControlEncoding(StringUtils.isNotBlank((CharSequence)encoding) ? encoding : "utf-8");
        try {
            logger.info("connecting...ftp\u670d\u52a1\u5668");
            ftpClient.connect(hostname, Integer.parseInt(port));
            ftpClient.login(username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                logger.info("connect failed...ftp\u670d\u52a1\u5668");
            } else {
                logger.info("connect successful...ftp\u670d\u52a1\u5668");
            }
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand("OPTS UTF8", "ON"))) {
                LOCAL_CHARSET = "UTF-8";
            }
            logger.info("initFtpClient.LOCAL_CHARSET:" + LOCAL_CHARSET);
            ftpClient.setControlEncoding(LOCAL_CHARSET);
        }
        catch (MalformedURLException e) {
            logger.error("\u521d\u59cb\u5316\u5f02\u5e38\uff0curl\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u521d\u59cb\u5316IO\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean uploadFile(FtpUploadParamDTO uploadParamDTO, FtpInitParamDTO paramDTO) {
        String fileName;
        String originPath;
        boolean flag = false;
        String path = uploadParamDTO.getPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path, originPath = uploadParamDTO.getOriginPath(), fileName = uploadParamDTO.getFileName()})) {
            String encoding = paramDTO.getServerEncoding();
            path = path.startsWith("/") ? path : "/" + path;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(originPath));
                FtpUtils.initFtpClient(paramDTO);
                ftpClient.setFileType(2);
                FtpUtils.createDirectory(FILE_CENTER + path);
                ftpClient.makeDirectory(path);
                ftpClient.enterLocalPassiveMode();
                ftpClient.changeWorkingDirectory(path);
                logger.info("\u5f00\u59cb\u4fdd\u5b58\u6587\u4ef6");
                String encodedFileName = fileName;
                if (StringUtils.isNotBlank((CharSequence)encoding)) {
                    encodedFileName = new String(fileName.getBytes(LOCAL_CHARSET), encoding);
                }
                logger.info("fileName\uff1a" + fileName + ",encodedFileName\uff1a{}" + encodedFileName);
                ftpClient.storeFile(encodedFileName, (InputStream)inputStream);
                logger.info("\u7ed3\u675f\u4fdd\u5b58\u6587\u4ef6");
                ((InputStream)inputStream).close();
                ftpClient.logout();
                logger.info("ftp\u4e0a\u4f20\u6587\u4ef6\u6210\u529f:path:{},fileName:{}", (Object)path, (Object)fileName);
                flag = true;
            }
            catch (Exception e) {
                logger.error("ftp\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25:path:{},fileName:{}:error:{}", new Object[]{path, fileName, e});
            }
            finally {
                if (ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u4e0a\u4f20\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38:{}", (Throwable)e);
                    }
                }
                if (null != inputStream) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u4e0a\u4f20\u6d41\u5173\u95ed\u5f02\u5e38:{}", (Throwable)e);
                    }
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(FtpUploadParamDTO uploadParamDTO, InputStream inputStream, FtpInitParamDTO paramDTO) {
        boolean flag = false;
        String path = uploadParamDTO.getPath();
        String fileName = uploadParamDTO.getFileName();
        if (null != inputStream && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path})) {
            String string = path = path.startsWith("/") ? path : "/" + path;
            if (StringUtils.isBlank((CharSequence)fileName)) {
                fileName = PublicUtil.getBusinessOrder();
            }
            try {
                FtpUtils.initFtpClient(paramDTO);
                ftpClient.setFileType(2);
                FtpUtils.createDirectory(FILE_CENTER + path);
                ftpClient.makeDirectory(path);
                ftpClient.changeWorkingDirectory(path);
                ftpClient.storeFile(fileName, inputStream);
                inputStream.close();
                ftpClient.logout();
                flag = true;
                logger.info("ftp\u4e0a\u4f20\u6587\u4ef6\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("ftp\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u8fde\u63a5\u5173\u95ed\u5931\u8d25", (Throwable)e);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("ftp\u4e0a\u4f20\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return flag;
    }

    private static boolean changeWorkingDirectory(String directory) {
        boolean flag = true;
        try {
            flag = ftpClient.changeWorkingDirectory(directory);
            if (flag) {
                logger.info("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u6210\u529f\uff01");
            } else {
                logger.info("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u5931\u8d25\uff01");
            }
        }
        catch (IOException e) {
            logger.error("ftp\u6539\u53d8\u76ee\u5f55\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        return flag;
    }

    private static boolean createDirectory(String remote) throws IOException {
        boolean success;
        block4: {
            logger.info("remote:" + remote);
            success = true;
            String directory = remote + "/";
            if ("/".equalsIgnoreCase(directory) || FtpUtils.changeWorkingDirectory(directory)) break block4;
            int start = 0;
            if (directory.startsWith("/")) {
                start = 1;
            }
            int end = directory.indexOf("/", start);
            StringBuilder path = new StringBuilder();
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes(LOCAL_CHARSET), SERVER_CHARSET);
                path.append("/").append(subDirectory);
                if (!FtpUtils.existFile(path.toString())) {
                    if (FtpUtils.makeDirectory(subDirectory)) {
                        FtpUtils.changeWorkingDirectory(subDirectory);
                        logger.info("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u6210\u529f");
                        continue;
                    }
                    logger.info("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                    FtpUtils.changeWorkingDirectory(subDirectory);
                    continue;
                }
                FtpUtils.changeWorkingDirectory(subDirectory);
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }

    private static boolean existFile(String path) throws IOException {
        boolean flag = false;
        ftpClient.enterLocalPassiveMode();
        FTPFile[] ftpFileArr = ftpClient.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    private static boolean makeDirectory(String dir) {
        boolean flag = true;
        try {
            flag = ftpClient.makeDirectory(dir);
            if (flag) {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                logger.info("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("ftp\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25:", (Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(FtpDownloadParamDTO downloadParamDTO, FtpInitParamDTO paramDTO) {
        boolean flag = false;
        String path = downloadParamDTO.getPath();
        String filename = downloadParamDTO.getFilename();
        String localPath = downloadParamDTO.getLocalPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{path, filename, localPath})) {
            OutputStream os = null;
            try {
                FTPFile[] ftpFiles;
                FtpUtils.initFtpClient(paramDTO);
                ftpClient.changeWorkingDirectory(path);
                for (FTPFile file : ftpFiles = ftpClient.listFiles()) {
                    if (!filename.equalsIgnoreCase(file.getName())) continue;
                    File localFile = new File(localPath + "/" + file.getName());
                    os = new FileOutputStream(localFile);
                    ftpClient.retrieveFile(file.getName(), os);
                    os.close();
                }
                ftpClient.logout();
                flag = true;
                logger.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u4e0b\u8f7d\u6587\u4ef6\u8fde\u63a5\u5173\u95ed\u5931\u8d25", (Throwable)e);
                    }
                }
                if (null != os) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u4e0b\u8f7d\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(FtpDeleteParamDTO deleteParamDTO, FtpInitParamDTO paramDTO) {
        boolean flag = false;
        String pathname = deleteParamDTO.getPathname();
        String filename = deleteParamDTO.getFilename();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pathname, filename})) {
            try {
                FtpUtils.initFtpClient(paramDTO);
                ftpClient.changeWorkingDirectory(pathname);
                ftpClient.dele(filename);
                ftpClient.logout();
                flag = true;
                logger.info("\u5220\u9664\u6587\u4ef6\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("ftp\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException e) {
                        logger.error("ftp\u5220\u9664\u6587\u4ef6\u8fde\u63a5\u5173\u95ed\u5931\u8d25", (Throwable)e);
                    }
                }
            }
        }
        return flag;
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}) && StringUtils.contains((CharSequence)fileName, (CharSequence)".")) {
            fileName = fileName.substring(fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

