/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidationPasswordUtils {
    private static Pattern PATTERN_0 = Pattern.compile("^[a-z0-9A-Z@$!%*#?&.]{6,}$");
    private static Pattern PATTERN_1 = Pattern.compile("^(?![0-9@$!%*#?&.]+$)(?![a-zA-Z@$!%*#?&.]+$)[0-9A-Za-z@$!%*#?&.]{8,}$");
    private static Pattern PATTERN_2 = Pattern.compile("^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[@$!%*#?&.\\s\\S]{8,}$");
    private static Pattern PATTERN_3 = Pattern.compile("^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])[a-zA-Z@$!%*#?&.\\d]{8,20}$");
    private static Pattern PATTERN_4 = Pattern.compile("^(?![a-zA-Z@$!%*#?&.]+$)(?![A-Z0-9@$!%*#?&.]+$)(?![A-Z\\W_]+$)(?![a-z0-9@$!%*#?&.]+$)(?![a-z\\W_]+$)(?![0-9\\W_]+$)[a-zA-Z0-9@$!%*#?&.\\W_]{8,}$");
    private static Pattern PATTERN_5 = Pattern.compile("^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*#?&.])[A-Za-z\\d@$!%*#?&.]{8,}$");
    private static Pattern PATTERN_6 = Pattern.compile("^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*#?&.])[A-Za-z\\d@$!%*#?&.]{8,16}$");
    private static Pattern PATTERN_7 = Pattern.compile("^(?=.*[A-Za-z])(?=.*\\d)(?=.*[@$!%*#?&.])[A-Za-z\\d@$!%*#?&.]{10,20}$");

    public static boolean checkPasswordComplexity(String passwordType, String password) {
        switch (passwordType) {
            case "0": {
                return ValidationPasswordUtils.checkPasswordNum(password);
            }
            case "1": {
                return ValidationPasswordUtils.checkPasswordNumAndLetter(password);
            }
            case "2": {
                return ValidationPasswordUtils.checkPasswordAa(password);
            }
            case "3": {
                return ValidationPasswordUtils.checkPassword(password);
            }
            case "4": {
                return ValidationPasswordUtils.checkPasswordAaNumSymbol(password);
            }
            case "5": {
                return ValidationPasswordUtils.checkPasswordMark(password);
            }
            case "6": {
                return ValidationPasswordUtils.checkPasswordMarkLeng(password);
            }
            case "7": {
                return ValidationPasswordUtils.checkPasswordAaNumSymbolTenLeng(password);
            }
        }
        return false;
    }

    public static String getEroorTips(String passwordType) {
        switch (passwordType) {
            case "0": {
                return "\u5bc6\u7801\u53ea\u9700\u8981\u6570\u5b57\u6216\u53ea\u9700\u8981\u5b57\u6bcd";
            }
            case "1": {
                return "\u5bc6\u7801\u9700\u8981\u5305\u542b\u6570\u5b57\u548c\u5b57\u6bcd\uff0c\u4e14\u81f3\u5c118\u4f4d";
            }
            case "2": {
                return "\u5bc6\u7801\u9700\u8981\u540c\u65f6\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\uff0c\u6570\u5b57\uff0c\u7279\u6b8a\u5b57\u7b26\uff08$@!%*#?&\uff09\uff0c\u4e14\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u4e14\u81f3\u5c118\u4f4d";
            }
            case "3": {
                return "\u5bc6\u7801\u957f\u5ea68\u523020\u4f4d\uff0c\u4e14\u5fc5\u987b\u5305\u542b\u6570\u5b57\uff0c\u5927\u5c0f\u5199\u5b57\u6bcd\uff0c\u548c\u7279\u6b8a\u7b26\u53f7(@$!%*#?&.)";
            }
            case "4": {
                return "\u5bc6\u7801\u9700\u8981\u5305\u542b\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7\u5176\u4e2d\u4efb\u610f\u4e09\u79cd\uff0c\u4e14\u81f3\u5c118\u4f4d";
            }
            case "5": {
                return "\u5bc6\u7801\u9700\u8981\u5305\u542b\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7(@$!%*#?&.)\uff0c\u4e14\u81f3\u5c118\u4f4d";
            }
            case "6": {
                return "\u5bc6\u7801\u957f\u5ea68\u523016\u4f4d\uff0c\u4e14\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u548c\u7279\u6b8a\u5b57\u7b26(@$!%*#?&.)\uff0c\u4e0d\u80fd\u6709\u6c49\u5b57";
            }
            case "7": {
                return "\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5b57\u6bcd\uff08\u4e0d\u533a\u5206\u5927\u5c0f\u5199\uff09\u3001\u6570\u5b57\u548c\u7279\u6b8a\u7b26\u53f7(@$!%*#?&.),\u957f\u5ea610\u4f4d\u523020\u4f4d";
            }
        }
        return "\u6570\u636e\u5e93\u5bc6\u7801\u914d\u7f6e\u9879\u4e3a\u7a7a";
    }

    private static boolean checkPasswordNum(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_0.matcher(password)).matches();
    }

    private static boolean checkPasswordNumAndLetter(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_1.matcher(password)).matches();
    }

    private static boolean checkPasswordAa(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_2.matcher(password)).matches();
    }

    private static boolean checkPassword(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_3.matcher(password)).matches();
    }

    private static boolean checkPasswordAaNumSymbol(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_4.matcher(password)).matches();
    }

    private static boolean checkPasswordMark(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_5.matcher(password)).matches();
    }

    private static boolean checkPasswordMarkLeng(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_6.matcher(password)).matches();
    }

    private static boolean checkPasswordAaNumSymbolTenLeng(String password) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)password) && (matcher = PATTERN_7.matcher(password)).matches();
    }
}

