package cn.gtmap.hlw.core.util.pdf;

import cn.gtmap.estateplat.core.support.xml.XmlUtils;
import cn.gtmap.estateplat.model.server.print.FdcqDzxx;
import cn.gtmap.estateplat.model.server.print.FdcqDzxxPage;
import cn.gtmap.estateplat.model.server.print.XmlData;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.dto.pdf.manage.OfficeDataToPrintXmlDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;

/**
 * @author xuehaifeng
 * @version 1.0
 * @date 2022/9/7 11:19
 * @description
 */
public class PdfExportUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportUtils.class);

    /**
     * 获取xml文件路径
     *
     * @param officeDataToPrintXml
     * @param slbh
     * @param path
     * @return
     */
    public static String getxmlPath(OfficeDataToPrintXmlDTO officeDataToPrintXml, String slbh, String path) {
        XmlUtils resultBinder = new XmlUtils(OfficeDataToPrintXmlDTO.class);
        String xml = resultBinder.entityToXml(officeDataToPrintXml, "UTF-8");
        xml = xml.replace("null", "");
        String filePt = path.substring(0, path.indexOf(File.separator)) + File.separator + getFilePath(slbh, UUID.randomUUID().toString());
        File file = new File(filePt);
        //判断文件夹是否存在，不存在创建文件夹
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        String filePath = filePt + File.separator + slbh + UUID.randomUUID().toString() + ".xml";
        boolean bcwjYz = outputStreamWriterXml(xml, filePath);
        if (bcwjYz) {
            return filePath;
        }
        return null;
    }

    /**
     * 获取文件路径
     *
     * @param slbh
     * @param fjlxdm
     * @return
     */
    public static String getFilePath(String slbh, String fjlxdm) {
        String date = new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime());
        return FilePathUtil.addDateDirectoriesToFilePath("fileCenter" + File.separator + "pdf_export" + File.separator + slbh + File.separator + fjlxdm + File.separator + date, "fileCenter");
    }

    /**
     * 输出xml
     *
     * @param content
     * @param filePath
     * @return
     */
    public static boolean outputStreamWriterXml(String content, String filePath) {
        if (StringUtils.isAnyBlank(filePath, content)) {
            return false;
        }
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter(new FileOutputStream(filePath), StandardCharsets.UTF_8);
            out.write(content);
            out.flush();
        } catch (IOException e) {
            LOGGER.error("outputStreamWriterXml:IOException:", e);
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                LOGGER.error("outputStreamWriterXml:IOException:", e);
            }
        }
        return true;
    }

    /**
     * 创建data类并塞入数据
     *
     * @param name
     * @param type
     * @param value
     * @return
     */
    public static XmlData zzData(String name, String type, String value) {
        XmlData xmlData = new XmlData();
        xmlData.setName(name);
        xmlData.setType(type);
        if (StringUtils.isBlank(value)) {
            value = "";
        }
        xmlData.setValue(value);
        return xmlData;
    }

    /**
     * 创建云签字表
     *
     * @param qlrZjhList
     * @param zbId
     * @param fdcqDzxxPageList
     * @return
     */
    public static void createYqZb(List<String> qlrZjhList, String zbId, List<FdcqDzxxPage> fdcqDzxxPageList) {
        FdcqDzxxPage qlrYqDetail = new FdcqDzxxPage();
        List<FdcqDzxx> qlrYqZb = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(qlrZjhList)) {
            for (String qlrZjh : qlrZjhList) {
                List<XmlData> yqZbDataList = new ArrayList<>();
                FdcqDzxx yqItem = new FdcqDzxx();
                yqItem.setId("权利人子项");
                yqZbDataList.add(PdfExportUtils.zzData("qlrYq_0_100", "String", CommonUtil.formatEmptyValue("签字区_" + qlrZjh)));
                yqItem.setXmlDataList(yqZbDataList);
                qlrYqZb.add(yqItem);
            }
        } else {
            List<XmlData> yqZbDataList = new ArrayList<>();
            FdcqDzxx yqItem = new FdcqDzxx();
            yqItem.setId("权利人子项");
            yqZbDataList.add(PdfExportUtils.zzData("qlrYq_0_100", "String", CommonUtil.formatEmptyValue("")));
            yqItem.setXmlDataList(yqZbDataList);
            qlrYqZb.add(yqItem);
        }
        qlrYqDetail.setId(zbId);
        qlrYqDetail.setRow(qlrYqZb);
        fdcqDzxxPageList.add(qlrYqDetail);
    }

}
