package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (GxYyOrg)表实体类BO
 *
 * @author makejava
 * @since 2023-06-01 11:39:31
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyOrg implements Serializable {
    private static final long serialVersionUID = 4983560265026323873L;
    /**
     * 组织ID
     */
    private String orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 父组织ID
     */
    private String parentOrgId;

    /**
     * 组织描述
     */
    private String orgDescription;

    /**
     * 组织编号
     */
    private String orgNumber;

    /**
     * 组织行政区代码
     */
    private String orgXzqdm;

    /**
     * 统一信用代码
     */
    private String orgTyxydm;

    /**
     * 证件类型（关联zd_zjlx）
     */
    private String orgZjlx;

    /**
     * 联系电话
     */
    private String orgLxdh;

    /**
     * 联系电话(脱敏数据)
     */
    private String orgLxdhTm;

    /**
     * 统一信用代码(脱敏数据)
     */
    private String orgTyxydmTm;

    /**
     * 法定代表人
     */
    private String orgFddbr;

    /**
     * 法定代表人电话
     */
    private String orgFddbrdh;

    /**
     * 法定代表人证件号
     */
    private String orgFddbrzjh;

    /**
     * 法定代表人证件类型（代码）
     */
    private String orgFddbrzjlx;

    /**
     * 法定代表人(脱敏数据)
     */
    private String orgFddbrTm;

    /**
     * 法定代表人电话(脱敏数据)
     */
    private String orgFddbrdhTm;

    /**
     * 法定代表人证件号(脱敏数据)
     */
    private String orgFddbrzjhTm;

    /**
     * 组织角色（0默认其他，1：公积金部门）
     */
    private String orgRole;

    /**
     * 组织详细地址
     */
    private String orgDz;

    /**
     * 组织详细地址脱敏
     */
    private String orgDzTm;

    /**
     * 组织所在市
     */
    private String orgSzshi;

    /**
     * 组织所在省
     */
    private String orgSzsheng;

    /**
     * 组织所在县
     */
    private String orgSzxian;

    /**
     * 公章内容
     */
    private Object orgGznr;

    /**
     * 领取方式（1自助机、2电子证、3纸质证）
     */
    private String lqfs;

    /**
     * 截止日期
     */
    private Date orgJzrq;

    /**
     * 到期提醒时间'
     */
    private Integer orgDqtxsj;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 是否集中缴费（0:否,1:是）
     */
    private String sfjzjf;

    /**
     * 是否月结(0:否；1:是)
     */
    private String sfyj;

    /**
     * 审核状态（0：未审核，1：审核通过，2：审核不通过；主要是企业注册使用）
     */
    private String shzt;

    /**
     * 代理人
     */
    private String orgDlr;

    /**
     * 代理人联系电话
     */
    private String orgDlrlxdh;

    /**
     * 代理人证件类型 （代码）
     */
    private String orgDlrzjlx;

    /**
     * 代理人证件号
     */
    private String orgDlrzjh;

    /**
     * 住房查询是否上传附件（0:否,1:是）
     */
    private String zfcxisupload;

    /**
     * 缴费方式
     */
    private String jffs;

    /**
     * 部门邮编
     */
    private String orgYb;

    /**
     * 由该部门发起的流程是否云签，0:否，1：是
     */
    private String orgSfyq;

    /**
     * 备案证号
     */
    private String bazh;

    /**
     * 是否允许授权（1 是，0 否）
     */
    private String sfyxsq;

    /**
     * 是否小微企业（1 是，0 否）
     */
    private String sfxwqy;

    /**
     * 是否挂账（1 是，0 否）
     */
    private String sfgz;
}

