package cn.gtmap.hlw.core.dto.sw.hs.clf.ah;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.dto.sw.hs.AhSwHsQueryDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.FpxxDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.JtcyxxDTO;
import cn.gtmap.hlw.core.dto.sw.hs.zlf.ah.QlrxxDTO;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/30
 * @description
 */
@Data
public class AhSwHsClfQueryDTO extends AhSwHsQueryDTO {
    /**
     * 不动产权证号
     */
    private String bdcqzh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 并案 ID
     */
    private String mergeid;
    /**
     * 并案业务总数
     */
    private String mergezs;
    /**
     * 行政区划代码
     */
    @ZdDzConfig(field = "xzqhDm", tableName = ZdDzConstant.ZD_DZ_XZQH, dmToDm = true)
    private String xzqhDm;
    /**
     * 行政区划名称
     */
    @ZdDzConfig(field = "xzqhMc", tableName = ZdDzConstant.ZD_DZ_XZQH, dmToMc = true)
    private String xzqhMc;
    /**
     * 乡镇街道代码
     */
    @ZdDzConfig(field = "jdxzDm", tableName = ZdDzConstant.ZD_DZ_JDXZ, dmToDm = true)
    private String jdxzDm;
    /**
     * 乡镇街道代码
     */
    @ZdDzConfig(field = "jdxzMc", tableName = ZdDzConstant.ZD_DZ_JDXZ, dmToMc = true)
    private String jdxzMc;
    /**
     * 小区名称
     */
    private String xqmc;
    /**
     * 小区代码
     */
    private String xqbm;
    /**
     * 房屋完整地址
     */
    private String fwwzdz;
    /**
     * 建筑面积
     */
    private String jzmj;
    /**
     * 套内面积
     */
    private String tnmj;
    /**
     * 总楼层
     */
    private String zlc;
    /**
     * 所在楼层
     */
    private String szlc;
    /**
     * 房屋幢号
     */
    private String fwzh;
    /**
     * 单元号
     */
    private String dyh;
    /**
     * 房间号
     */
    private String fjh;
    /**
     * 建筑结构类型代码
     */
    @ZdDzConfig(field = "jzjglxDm", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToDm = true)
    private String jzjglxDm;
    /**
     * 建筑结构类型名称
     */
    @ZdDzConfig(field = "jzjglxMc", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToMc = true)
    private String jzjglxMc;
    /**
     * 建筑年代
     */
    private String jznd;
    /**
     * 交易日期
     */
    private String jyrq;
    /**
     * 不动产部门房屋用途
     */
    private String bdcFwyt;
    /**
     * 房屋用途
     */
    @ZdDzConfig(field = "fwyt", tableName = ZdDzConstant.ZD_DZ_FWYT, dmToDm = true)
    private String fwyt;
    /**
     * 产权使用年限
     */
    private String cqsynx;
    /**
     * 房产类型代码
     */
    @ZdDzConfig(field = "fclxDm", tableName = ZdDzConstant.ZD_DZ_FCLX, dmToDm = true)
    private String fclxDm;
    /**
     * 房产类型名称
     */
    @ZdDzConfig(field = "fclxMc", tableName = ZdDzConstant.ZD_DZ_FCLX, dmToMc = true)
    private String fclxMc;
    /**
     * 房产交易方式代码
     */
    @ZdDzConfig(field = "fcjyfsDm", tableName = ZdDzConstant.ZD_DZ_JYFS, dmToDm  = true,defaultValue = "01")
    private String fcjyfsDm;
    /**
     * 房产交易方式名称
     */
    @ZdDzConfig(field = "fcjyfsMc", tableName = ZdDzConstant.ZD_DZ_JYFS, dmToMc = true,defaultValue = "买卖")
    private String fcjyfsMc;
    /**
     * 交易价格
     */
    private String jyjg;
    /**
     * 交易单价
     */
    private String jydj;
    /**
     * 业务受理单号
     */
    private String sldh;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 合同金额
     */
    private String htje;
    /**
     * 合同签订日期
     */
    private String htqdrq;
    /**
     * 增值税税额
     */
    private String zzsse;
    /**
     * 增值税税率
     */
    private String zzssl;
    /**
     * 不含增值税金额
     */
    private String bhzzsje;
    /**
     * 经办人姓名
     */
    private String jbrxm;
    /**
     * 经办人电话
     */
    private String jbrdh;
    /**
     * 房屋内码
     */
    private String fwnm;
    /**
     * 直系亲属买卖标记
     */
    private String zxqsjybj;
    /**
     * 个人所得税差额征收标记
     */
    private String grsdscezsbj;
    /**
     * 权证填制日期
     */
    private String qztzrq;
    /**
     * 前次交易类型编码
     */
    @JSONField(name = "qcjylx_dm")
    private String qcjylxDm;
    /**
     * 前次交易类型名称
     */
    @JSONField(name = "qcjylx_mc")
    private String qcjylxMc;
    /**
     * 前次交易日期
     */
    private String qcjyrq;
    /**
     * 前次交易价格
     */
    private String qcjyjg;
    /**
     * 合同价格是否含税
     */
    private String htjgsfhs;
    /**
     * 中介名称
     */
    @JSONField(name = "zj_mc")
    private String zjMc;
    /**
     * 中介纳税人识别号
     */
    @JSONField(name = "zj_nsrsbh")
    private String zjNsrsbh;
    /**
     * 附属物类型
     */
    private String fssslx;
    /**
     * 拆迁安置补偿标记
     */
    private String cqazbcbj;
    /**
     * 涉税附件图片总数
     */
    private String sstpfjzs;
    /**
     * 附属面积
     */
    private String fsmj;
    /**
     * 附属金额
     */
    private String fsje;
    /**
     * 不动产部门的附记信息
     */
    private String fjxx;
    /**
     * 房屋信息备注
     */
    private String bz;
    /**
     * 是否与卖方为直系亲属
     */
    private String sfzxqs;
    /**
     * 是否自建房
     */
    private String sfzj;
    /**
     * 车库面积
     */
    private String ckmj;
    /**
     * 阁楼面积
     */
    private String glmj;
    /**
     * 地下室面积
     */
    private String dxsmj;
    /**
     * 跃层面积
     */
    private String ycmj;
    /**
     * 柴间面积
     */
    private String cjmj;
    /**
     * 庭院面积
     */
    private String tymj;
    /**
     * 转让比例
     */
    private String zrbl;
    /**
     * 整栋建筑面积
     */
    private String zdjzmj;
    /**
     * 土地分摊面积
     */
    private String tdftmj;
    /**
     * 带押过户标记
     */
    private String dyghbj;

    /**
     * 所得税减除项目
     */
    private SdsjcxmDTO sdsjcxm;
    /**
     * 土地出让金
     */
    private TdcrjDTO tdcrj;

    /**
     * 出让方信息列表
     */
    private List<QlrxxDTO> crfxxlb;
    /**
     * 受让方信息列表
     */
    private List<QlrxxDTO> srfxxlb;
    /**
     * 出让方家庭成员列表
     */
    private List<JtcyxxDTO> crfjtcylb;
    /**
     * 受让方家庭成员列表
     */
    private List<JtcyxxDTO> srfjtcylb;
}
