package cn.gtmap.hlw.core.dto.zjcj;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import lombok.Data;

/**
 * @author <a href="mailto:chenjia@gtmap.cn">chenjia</a>
 * @version 1.0, 2025/5/21
 * @description 不动产单元信息
 */
@Data
public class ZjHlwSqxxBdcdyxxDTO {
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 附记
     */
    private String fj;
    /**
     * 其他权利状况
     */
    private String qtqlzk;
    /**
     * 原业务号（不传）
     */
    private String yywh;
    /**
     * 不动产单元编号（3.1.2查询得到）
     */
    private String bdcdybh;
    /**
     * 房屋面积
     */
    private String mj;
    /**
     * 原项目id（不传）
     */
    private String yxmid;
    /**
     * 房屋朝向（传名称）
     */
    private String fwcx;
    /**
     * 建成年份
     */
    private String jcnf;
    /**
     * 竣工时间
     */
    private String jgsj;
    /**
     * 是否顶层
     */
    private String sfdc;
    /**
     * 所在层
     */
    private String szc;
    /**
     * 总层数
     */
    private String zcs;
    /**
     * 房屋结构
     */
    private String fwjg;
    /**
     * 定着物用途（3.1.2返回的规划用途）
     */
    private String dzwyt;
    /**
     * 是否抵押
     */
    @ZdDzConfig(field = "sfdy", tableName = "SFDY", dmToDm = true)
    private String sfdy;
    /**
     * 是否查封
     */
    @ZdDzConfig(field = "sfcf", tableName = "SFCF", dmToDm = true)
    private String sfcf;
    /**
     * 房屋性质
     */
    private String fwxz;
    /**
     * 规划用途
     */
    private String ghyt;
    /**
     * 房屋类型
     */
    private String fwlx;
    /**
     * 是否存在异议
     */
    @ZdDzConfig(field = "sfyy", tableName = "SFYY", dmToDm = true)
    private String sfyy;
    /**
     * 是否锁定
     */
    @ZdDzConfig(field = "sfsd", tableName = "SFSD", dmToDm = true)
    private String sfsd;
    /**
     * 宗地宗海面积
     */
    private String zdzhmj;
    /**
     * 竣工日期
     */
    private String jgrq;
    /**
     * 宗地宗海权利性质
     */
    private String zdzhqlxz;
    /**
     * 宗地宗海用途
     */
    private String zdzhyt;
    /**
     * 是否预抵押
     */
    @ZdDzConfig(field = "sfydy", tableName = "SFYDY", dmToDm = true)
    private String sfydy;
    /**
     * 是否预查封
     */
    @ZdDzConfig(field = "sfycf", tableName = "SFYCF", dmToDm = true)
    private String sfycf;
    /**
     * 单元号
     */
    private String dyh;
    /**
     * 幢号
     */
    private String zh;
    /**
     * 专有建筑面积
     */
    private Double zyjzmj;
    /**
     * 分摊建筑面积
     */
    private Double ftjzmj;
    /**
     * 阁楼面积
     */
    private Double glmj;
    /**
     * 储藏室面积
     */
    private Double ccsmj;
    /**
     * 车库面积
     */
    private Double ckmj;
    /**
     * 分摊土地面积
     */
    private Double fttdmj;
    /**
     * 独用土地面积
     */
    private Double dytdmj;

    /**
     * 是否预告
     */
    @ZdDzConfig(field = "sfyg", tableName = "SFYG", dmToDm = true)
    private String sfyg;
}
