package cn.gtmap.hlw.core.dto.sqxx.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:06
 * @description 中介信息
 */
@Data
public class ZjxxDTO implements Serializable {
    /**  申请ID(gx_yy_sqxx.SQID) */
    private String sqid;

    /** 受理编号(gx_yy_sqxx.SLBH) */
    private String slbh;

    /** 中介名称 */
    private String zjmc;

    /** 中介证件种类 */
    private String zjzjzl;

    /** 中介证件编号 */
    private String zjzjbh;

    /** 中介代理人名称 */
    private String zjdlrmc;

    /**中介代理人证件种类 */
    private String zjdlrzjzl;

    /**中介代理人证件编号 */
    private String zjdlrzjbh;

    /**中介代理人联系电话 */
    private String zjdlrlxdh;

    /**主键(使用UUID通用工具类的hex32()方法生成) */
    private String id;

    /**创建时间*/
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**修改时间*/
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /**脱敏字段中介名称*/
    private String zjmcTm;

    /**脱敏字段中介证件编号*/
    private String zjzjbhTm;

    /**脱敏字段中介代理人名称*/
    private String zjdlrmcTm;

    /**脱敏字段中介代理人证件编号*/
    private String zjdlrzjbhTm;

    /** 脱敏字段中介代理人联系电话 */
    private String zjdlrlxdhTm;

    /** 地址 */
    private String dz;

    /** 备案证号*/
    private String bazh;

    /** 联系电话*/
    private String lxdh;

    /** 从业资质证号*/
    private String cyzzzh;

    /**法人代表*/
    private String frdb;

    /**法人代表证件种类*/
    private String frdbzjzl;

    /**法人代表证件号*/
    private String frdbzjh;


}
