package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxJkxx;

import java.util.List;

/**
 * 申请信息-缴库信息表(GxYySqxxJkxx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:45
 */
public interface GxYySqxxJkxxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param jkid 主键
     * @return 实例对象
     */
    GxYySqxxJkxx get(String jkid);

    /**
     * 新增数据
     *
     * @param gxYySqxxJkxx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxJkxx gxYySqxxJkxx);

    /**
     * 修改数据
     *
     * @param gxYySqxxJkxx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxJkxx gxYySqxxJkxx);

    /**
     * 通过sqlbhList查询集合数据
     *
     * @param sqlbhList
     * @return 实例对象
     */
    List<GxYySqxxJkxx> list(List<String> sqlbhList);

    /**
     * 通过sqidList删除数据
     *
     * @param slbhList
     * @return 实例对象
     */
    int deleteBySlbhList(List<String> slbhList);

    /**
     * 根据sqid查询
     *
     * @param sqid 实例对象
     * @return 影响行数
     */
    GxYySqxxJkxx getBySqid(String sqid);
    /**
     * 根据sqid查询
     *
     * @param slbh 受理编号
     * @return 影响行数
     */
    GxYySqxxJkxx getBySlbh(String slbh);

    /**
     * 新增数据或修改数据
     *
     * @param sqxxJkxx
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxJkxx sqxxJkxx);
}

