package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxYs;

import java.util.List;

/**
 * (GxYySqxxYs)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:51
 */
public interface GxYySqxxYsRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param ysGuid 主键
     * @return 实例对象
     */
    GxYySqxxYs get(String ysGuid);

    /**
     * 新增数据
     *
     * @param gxYySqxxYs 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxYs gxYySqxxYs);

    /**
     * 修改数据
     *
     * @param gxYySqxxYs 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxYs gxYySqxxYs);

    /**
     * 通过sqlbhList查询集合数据
     *
     * @param sqlbhList
     * @return 实例对象
     */
    List<GxYySqxxYs> getBySlbhList(List<String> sqlbhList);
    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
     List<GxYySqxxYs> getBySlbh(String slbh);

    /**
     * 通过sqlbhList删除数据
     *
     * @param slbhList
     * @return 实例对象
     */
    int deleteBySlbhList(List<String> slbhList);

    /**
     * 更新预审状态
     *
     * @param yszt
     * @param slbh
     * @return 实例对象
     */
    void updateYszt(String yszt, String slbh);
}

