package cn.gtmap.hlw.core.dto.sqxx.save;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:10
 * @description 收费信息
 */
@Data
public class SfxxDTO implements Serializable {
    /**主键ID*/
    private String id;

    /** 受理编号(gx_yy_sqxx.SLBH) */
    private String slbh;

    /**票据号（非税缴款书编号）*/
    private String pjh;

    /**权利人类型（QLRLX字典）*/
    private String qlrlx;

    /**缴费人证件号*/
    private String jfrzjh;

    /**缴费人名称*/
    private String jfrmc;

    /**收费项目代码（SFXM字典）*/
    private String sfxmdm;

    /**收费标准（元）*/
    private String sfbz;

    /**数量*/
    private String sl;

    /**数量单位代码（SLDW字典）*/
    private String sldwdm;

    /**应缴金额（元）*/
    private String yjje;

    /**应缴金额合计（元）*/
    private String yjjehj;

    /**权利人类型应缴金额合计*/
    private String qlrlxyjjehj;

    /**创建时间*/
    private Date createTime;

    /**修改时间*/
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /** 修改人员(gx_yy_user.USER_GUID)*/
    private String updateUser;

}
