package cn.gtmap.hlw.core.util.encryption;

import cn.gtmap.hlw.core.base.ApiEncryptBody;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.encryption.sm4.Sm4Util;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author jianglin
 * @Date 2024/6/27
 * @Description 接口出入参-加解密-工具类
 */
@Slf4j
public class ApiSecurityUtils {

    /**
     * @param sm4KeyBySm2 经过Sm2加密的sm4key
     * @param decryptStr  经过sm4加密的数据
     * @return 解密后的数据
     */
    public static String decrypt(String sm4KeyBySm2, String decryptStr) {
        String sm4Key = Sm2lib.decode(sm4KeyBySm2);
        return Sm4Util.decryptEcb(sm4Key, decryptStr);
    }

    /**
     * @param encryptStr     要加密的数据
     * @param frontPublicKey 前端公钥
     * @return 加密后的数据
     */
    public static ApiEncryptBody encrypt(String encryptStr, String frontPublicKey) throws Exception {
        //生成一个随机的sm4加密key
        String sm4Key = Sm4Util.generateKey();
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        ApiEncryptBody apiEncryptRes = new ApiEncryptBody();
        //用前端公钥(用前端的公钥)，sm2加密sm4Key
        apiEncryptRes.setParamid(Sm2lib.encode(sm4Key, frontPublicKey));
        apiEncryptRes.setData(data);
        apiEncryptRes.setFrontKey(frontPublicKey);
        return apiEncryptRes;
    }

    //加解密测试
    public static void main(String[] args) throws Exception {
        String pubKey = "c2f1831616943efe504bde6b45d59eea953f04d31ecebd4c59dffd6733c7a066c7a9c14cb2c54564187891f72753fea7f56d07b19d52e9076263564def41b8e7";

        //前端入参 解密
        String dataEncrypt = "cf78a6b4d5b4944afd0d7430660bda390c14adf6e79b5bb163258f333faa59798b96e7a01bfd7674e47493a14c678c752279f0e85cd1a5475996e697d44ac1a3e196ec64b0a630fcbf993983ad4cd5928e37332c8418e9ce17a7b1efd5ea56aab870ebe8adb8930d98e1559102495a583810a3318d6090ac15341ecefadf4e587f5effb4d0aab90e6e1e8d62a7d21d8b2455a9369392fa22cfa3afe1bd9d2b195dd3b8011c01c653234157e1a2b52ed27779969cf71ef2cb4bca4511c7bca942b19a719a390ef2e473ddb356586dbd18be780e5d3ee1bf60de44e6780892b69cf5ffa67b07bb0ddbbe39a3c5d7ba5fbbeec8ceec346110faf7191270e66dae62cec9702a570f2bdbb48d4784ee4d7d02e70c14990503ffc47986f6eed8cc6f4121edee2345863e9539dbaee19c022786a2a7811d621dd90741682a9db4ab3b47f14e919e48a686462235168df340c5c3d301a3ff3ea268f2962cd1d9d127ba24b9be9e91d7d3095c235ddb1feb84da4eed06ee829289fc4b57aba3946c09a2b919a26c707d0d5b529fb611304101a814fa48910f5322df9a36d92c74d8dd19c9b1acf2392a9beebaa348540bfc6e21d306d0e0f87e51e7a36c0a552b70938d9f344bfd39d09b7d83b258ac6fae793a0389909ebedb12696a0b93a24ef2a93d5d7dada3d61876dd5f7d52f2b295fc99d0226173d3b1b29ced33773be55dcec52468764a3be9f51d2bc7f556b81d8d6f02ca9e855ac8666a415643ddbfe3407b6d5949478b413183dc47a27ac624afcd39afd602ed742c918da3758d8ec8c3bd92548aa9970dc5408813fc3bba2bae395a138c9733bd73d158dd106607bfae37394f5d5844f4f430c40f6a242e94d33be7d45928494630c30b48786f22eaa3384878cc7f61c0e9864b074825d3cf901177b9184e75a504504357daa14937c9200659e8b81e0739a5667c8c6c4d3941fcf29e298f2c77ff9ee27322237cf575a1aba5bc742fb258bd23019562c0170d5239c7411dc82a75209ef37f355f9ce5a6a52f967328aaae65c621f8388851843ed87328f8b3db83b3ca5df0eb97eb92093d4b2a4276a3fd532ad03d0702d3bd7b2f3819f477d8b20536253d2069d9cf1ce297aaf6a5bfc7e46f4e02a375ff19282f2676b7df8e6c6c88a5fe27cffa5706e29a776f0025b7aed1d048ec83ca8614ac023fa369e7c23cd4a1033e3a9a972caad2daea566dd7525cbe7a5062ea03927409459fe5e22a9cf5a07d6cdd0fbf9c29173dfd8f202a56ce6a1747c9f3a078a6a81a07d1ded79c4a66fbb9f974f34a9bde0e54b98aaac3d603e4d04ec06961e12b57d90fc9584d0d56593aeea4bff6c198fba359677dba384b59d140692a737695cfa3bda1efa0822459c73db28fc2f8eefc9e584ad73e08c3080dee563a2c306e8a067ad89f8aa4251b3fa10547f046454c12f57b68cecbe65587a99cb805dd102ef7ba25f4b36c9095c841614143df5473902ca1f86ee8fc7936a414b1b062";
        String paramid = "040c91479237a056e0c46f8a7c55067408d63fde9d22e70578a9cb78013338f0acd707b971e4ad82a09887d9e52b182772abc0d4afce7ac4b567980dbc1efa9863171a014916862d3f93677af34f721336523e4b716904bf9f8dbc80478633c1448b32d951b62a32f6e965cac5f083d1724a350584346688c7406703f7ff37b4199f68124d7be19beeab10fe3b";
        String qdData = ApiSecurityUtils.decrypt(paramid, dataEncrypt);
        System.out.println(qdData);

/*        //生成前端加密密文
        //生成一个随机的sm4加密key
        String sm4Key = "B13356B451572BFC3478AC20F0E3E163";
        //前端入参
        String encryptStr = "{\"slbh\":\"W202503190079\",\"processId\":\"b912481754e64dfea519b07745f68dc7\",\"anid\":\"\"}";
        //加密
        String data = Sm4Util.encryptEcb(sm4Key, encryptStr);
        String paramid2 = Sm2lib.encode(sm4Key);

        ApiEncryptBody body = new ApiEncryptBody();
        body.setData(data);
        body.setParamid(paramid2);
        body.setFrontKey(pubKey);

        System.out.println(JSON.toJSONString(body));*/
    }

}
