package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.sign.log.SilentLogByPageParamDTO;
import cn.gtmap.hlw.core.model.GxYyRzQz;

import java.util.List;

/**
 * 静默签章日志(GxYyRzqz)表数据库访问层
 *
 * @author makejava
 * @since 2023-07-10 15:19:36
 */
public interface GxYyRzQzRepository {

    /**
     * 保存或修改
     *
     * @param gxYyRzQz
     */
    void saveOrUpdate(GxYyRzQz gxYyRzQz);

    /**
     * 分页查询
     *
     * @param paramsDTO
     */
    PageInfo<GxYyRzQz> getByPage(SilentLogByPageParamDTO paramsDTO);

    /**
     * 通过受理编号查询
     *
     * @param slbh 受理编号
     */
    List<GxYyRzQz> getBySlbh(String slbh);

    /**
     * 通过受理编号和附件类型查询
     *
     * @param slbh 受理编号
     * @param fjlx 附件类型
     */
    List<GxYyRzQz> getBySlbhAndFjlx(String slbh, String fjlx);
}

