package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/10/12
 * @description
 */
@Getter
@AllArgsConstructor
public enum JflxEnum {
    /**
     * 单独缴费
     */
    JFLX_JF("1", "单独缴费"),
    /**
     * 单独缴税
     */
    JFLX_JS("2", "单独缴税"),
    /**
     * 税费同缴
     */
    JFLX_SFTJ("3", "税费同缴");

    @Getter
    private String code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (JflxEnum xq : JflxEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
