package cn.gtmap.hlw.core.dto.sqxx.lqxx;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/6/27 19:30
 * @description LqxxQueryResultDTO
 */
@Data
public class LdxxQueryResultDTO {

    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 宗地面积
     */
    private String zdmj;
    /**
     * 是否抵押（0是，1否）
     */
    private String sfdy;
    /**
     * 是否查封（0是，1否）
     */
    private String sfcf;
    /**
     * 林种
     */
    private String lz;
    /**
     * 权利类型
     */
    private String qllx;
    /**
     * 权利类型名称
     */
    private String qllxmc;
    /**
     * 林地使用开始期限
     */
    private String ldsyksqx;
    /**
     * 林地使用结束期限
     */
    private String ldsyjsqx;
    /**
     * 林班
     */
    private String lb;
    /**
     * 小班
     */
    private String xb;
    /**
     * 造林年度
     */
    private String zlnd;
    /**
     * 株数
     */
    private String zs;
    /**
     * 主要树种
     */
    private String zysz;
    /**
     * 附记
     */
    private String fj;
    /**
     * 林地使用期限是否永久
     */
    private String ldsyqxsfyj;
    /**
     * 森林类别代码
     */
    private String sllbdm;
    /**
     * 森林类别名称
     */
    private String sllbmc;
    /**
     * 事权等级
     */
    private String sqdj;
    /**
     * 小地名
     */
    private String xdm;
    /**
     * 起源
     */
    private String qy;
    /**
     * 宗地用途代码
     */
    private String zdytdm;
    /**
     * 宗地用途名称
     */
    private String zdytmc;
    /**
     * 宗地权利性质代码
     */
    private String zdqlxzdm;
    /**
     * 宗地权利性质名称
     */
    private String zdqlxzmc;
    /**
     * 定作物面积
     */
    private String dzwmj;
    /**
     * 发包方名称
     */
    private String fbfmc;
    /**
     * 使用权（承包）面积
     */
    private String syqmj;
    /**
     * 森林、林木使用权人
     */
    private String sllmshiyqr;
    /**
     * 森林、林木所有权人
     */
    private String sllmsyqr;
    /**
     * 权利人信息
     */
    private List<LqxxQueryQlrxxResultDTO> qlrList;

}
