/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.http;

import cn.gtmap.estateplat.register.common.util.PublicUtil;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.web.HttpMethodEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.core.util.http.HttpGetWithEntity;
import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.multipart.MultipartFile;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    public static final String CHARSET = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json) {
        int statusCode;
        String httpStr;
        long start;
        block16: {
            start = System.currentTimeMillis();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            statusCode = -999;
            try {
                httpPost.setConfig(requestConfig);
                if (StringUtils.isNotBlank((CharSequence)json)) {
                    StringEntity stringEntity = new StringEntity(json, CHARSET);
                    stringEntity.setContentType("application/json");
                    httpPost.setEntity((HttpEntity)stringEntity);
                }
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block16;
            }
            catch (Exception ex) {
                try {
                    long end2 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end2));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil doPost error:" + ex2.getMessage());
                        }
                    }
                    long end3 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end3));
                    MDC.put((String)"API_NAME", (String)apiName);
                    if (StringUtils.equals((CharSequence)apiName, (CharSequence)"es\u67e5\u8be2")) throw throwable;
                    if (apiUrl.contains("wwsq/tsWwsqFjxx") || apiUrl.contains("storages/multipart/upload")) {
                        log.info("request to:{},param.length:{},response code:{},cost {} ms", new Object[]{apiUrl, json.length(), statusCode, end3});
                    } else {
                        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end3});
                    }
                    if (apiUrl.contains("zzgx/zzxxxz")) {
                        log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)httpStr.length());
                        throw throwable;
                    }
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil doPost error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        if (StringUtils.equals((CharSequence)apiName, (CharSequence)"es\u67e5\u8be2")) return httpStr;
        if (apiUrl.contains("wwsq/tsWwsqFjxx") || apiUrl.contains("storages/multipart/upload")) {
            log.info("request to:{},param.length:{},response code:{},cost {} ms", new Object[]{apiUrl, json.length(), statusCode, end});
        } else {
            log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
        }
        if (apiUrl.contains("zzgx/zzxxxz")) {
            log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)httpStr.length());
            return httpStr;
        }
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json, String contentType) {
        int statusCode;
        String httpStr;
        long start;
        block10: {
            start = System.currentTimeMillis();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            statusCode = -999;
            try {
                httpPost.setConfig(requestConfig);
                if (StringUtils.isNotBlank((CharSequence)json)) {
                    StringEntity stringEntity = new StringEntity(json, CHARSET);
                    stringEntity.setContentType(contentType);
                    httpPost.setEntity((HttpEntity)stringEntity);
                }
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block10;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil doPost error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil doPost error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, String json, Map<String, String> headerMap) {
        int statusCode;
        String httpStr;
        long start;
        block11: {
            start = System.currentTimeMillis();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            statusCode = -999;
            try {
                httpPost.setConfig(requestConfig);
                StringEntity stringEntity = new StringEntity(json, CHARSET);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpPost.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                statusCode = response.getStatusLine().getStatusCode();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block11;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    public static String sendPostRequest(String url, List<MultipartFile> files, Map<String, String> params) throws URISyntaxException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        ContentType contentType = ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                String value = e.getValue();
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                builder.addTextBody(e.getKey(), value, contentType);
            }
        }
        if (files != null && !files.isEmpty()) {
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (MultipartFile file : files) {
                builder.addBinaryBody("file", file.getBytes(), ContentType.MULTIPART_FORM_DATA, file.getOriginalFilename());
            }
            HttpEntity multipart = builder.build();
            httpPost.setEntity(multipart);
        }
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity responseEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        httpClient.close();
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String url, List<MultipartFile> files, Map<String, String> otherParams, Map<String, String> headerParams) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headerParams != null && headerParams.size() > 0) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    String string = entry.getValue();
                    String string2 = entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    httpPost.setHeader(string2, string);
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("utf-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (MultipartFile multipartFile : files) {
                if (multipartFile == null) continue;
                String string = multipartFile.getOriginalFilename();
                builder.addBinaryBody("file", multipartFile.getInputStream(), ContentType.MULTIPART_FORM_DATA, string);
            }
            ContentType contentType = ContentType.create((String)"application/json", (Charset)Charset.forName(CHARSET));
            if (otherParams != null && otherParams.size() > 0) {
                for (Map.Entry<String, String> entry : otherParams.entrySet()) {
                    String value = entry.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    builder.addTextBody(entry.getKey(), value, contentType);
                }
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = closeableHttpResponse.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            log.error("\u4f7f\u7528httpclint \u53d1\u9001\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    log.error("httpclint\u5173\u95ed\u5f02\u5e38\uff1a{}", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String apiUrl, String apiName, Map<String, Object> params) {
        int statusCode;
        String httpStr;
        long start;
        block10: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = null;
            statusCode = -999;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(apiUrl);
            try {
                httpPost.setConfig(requestConfig);
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                response = httpClient.execute((HttpUriRequest)httpPost);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block10;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostForBase64(String apiUrl, String apiName, Map<String, Object> params) {
        int statusCode;
        String httpStr;
        long start;
        block11: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = null;
            statusCode = -999;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(apiUrl);
            try {
                httpPost.setConfig(requestConfig);
                httpPost.setHeader("Content-Type", "multipart/form-data");
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                response = httpClient.execute((HttpUriRequest)httpPost);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    httpStr = Base64.encode((InputStream)instream);
                }
                if (response == null) break block11;
            }
            catch (Exception ex) {
                try {
                    long end2 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end2));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end3 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end3));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end3});
                    if (!StringUtils.isNotBlank(httpStr)) throw throwable;
                    log.info("result.size:{}", new Object[]{httpStr.length()});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
        if (!StringUtils.isNotBlank((CharSequence)httpStr)) return httpStr;
        log.info("result.size:{}", new Object[]{httpStr.length()});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doHttpsPost(String apiUrl, Map<String, Object> params, Map<String, String> header) {
        int statusCode;
        String httpStr;
        long start;
        block20: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = null;
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost httpPost = new HttpPost(apiUrl);
            try {
                httpPost.setConfig(requestConfig);
                httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                if (MapUtils.isNotEmpty(header)) {
                    for (Map.Entry<String, String> entry : header.entrySet()) {
                        httpPost.addHeader(entry.getKey(), entry.getValue());
                    }
                }
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CHARSET)));
                response = httpClient.execute((HttpUriRequest)httpPost);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block20;
            }
            catch (Exception ex) {
                try {
                    long end2 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end2));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end3 = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end3));
                    if (apiUrl.contains("integrated/pictureInfo")) {
                        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, "\u5165\u53c2\u592a\u957f\uff0c\u4e0d\u8f93\u51fa", statusCode, end3});
                    } else {
                        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end3});
                    }
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        if (apiUrl.contains("integrated/pictureInfo")) {
            log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, "\u5165\u53c2\u592a\u957f\uff0c\u4e0d\u8f93\u51fa", statusCode, end});
        } else {
            log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
        }
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doHttpsGet(String apiUrl, Map<String, Object> params) {
        int statusCode;
        String httpStr;
        long start;
        block14: {
            start = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpStr = null;
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            try {
                ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                    pairList.add(pair);
                }
                URIBuilder uriBuilder = new URIBuilder(apiUrl);
                uriBuilder.addParameters(pairList);
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                httpStr = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (response == null) break block14;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil post error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil post error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
        log.info("result:{}", new Object[]{httpStr});
        return httpStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream downloadFileStream(String apiUrl, String json) {
        int statusCode;
        ByteArrayOutputStream byteOutStream;
        Object httpStr;
        long start;
        block10: {
            start = System.currentTimeMillis();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            httpStr = null;
            HttpPost httpPost = new HttpPost(apiUrl);
            CloseableHttpResponse response = null;
            byteOutStream = null;
            statusCode = -999;
            try {
                HttpEntity entity;
                httpPost.setConfig(requestConfig);
                StringEntity stringEntity = new StringEntity(json, CHARSET);
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                response = httpClient.execute((HttpUriRequest)httpPost);
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 && (entity = response.getEntity()) != null && entity.getContent() != null) {
                    byteOutStream = HttpUtil.cloneInputStream(entity.getContent());
                }
                if (response == null) break block10;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil post error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        catch (IOException ex2) {
                            log.error("HttpUtil downloadFileStream error:" + ex2.getMessage());
                        }
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
                    log.info("result:{}", new Object[]{httpStr});
                    throw throwable;
                }
            }
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                log.error("HttpUtil downloadFileStream error:" + ex.getMessage());
            }
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, json, statusCode, end});
        log.info("result:{}", new Object[]{httpStr});
        return byteOutStream;
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                byteOutStream.write(buffer, 0, len);
            }
            byteOutStream.flush();
            return byteOutStream;
        }
        catch (IOException e) {
            log.warn("copy InputStream error\uff0c{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, String apiName, Map<String, Object> params) {
        int statusCode;
        String result;
        String apiUrl;
        long start;
        block9: {
            start = System.currentTimeMillis();
            StringBuffer param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (httpClient == null) break block9;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
                    log.info("result:{}", new Object[]{result});
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString(params), statusCode, end});
        log.info("result:{}", new Object[]{result});
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, String apiName, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block11: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
                if (httpClient == null) break block11;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    MDC.put((String)"API_NAME", (String)apiName);
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
                    log.info("result:{}", new Object[]{result});
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        MDC.put((String)"API_NAME", (String)apiName);
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
        log.info("result:{}", new Object[]{result});
        return result;
    }

    public static String doGetForBase64(String url, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block16: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block16;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
                    if (url.contains("syd/business/download")) {
                        log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)result.length());
                    } else {
                        log.info("result:{}", new Object[]{result});
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
        if (url.contains("syd/business/download")) {
            log.info("result to {} : \u51fa\u53c2\u8fc7\u6ee4 {}", (Object)apiUrl, (Object)result.length());
        } else {
            log.info("result:{}", new Object[]{result});
        }
        return result;
    }

    public static InputStream doGetForInputStream(String url, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        CloseableHttpClient httpClient;
        String apiUrl;
        StringBuffer param;
        long start;
        block12: {
            InputStream inputStream;
            block13: {
                start = System.currentTimeMillis();
                param = new StringBuffer();
                int i = 0;
                if (params != null) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        String key = entry.getKey();
                        if (i == 0) {
                            param.append("?");
                        } else {
                            param.append("&");
                        }
                        ++i;
                        param.append(key).append("=").append(params.get(key));
                    }
                }
                apiUrl = url + param;
                Object result = null;
                httpClient = HttpClients.createDefault();
                statusCode = -999;
                try {
                    HttpGet httpGet = new HttpGet(apiUrl);
                    if (headerMap != null) {
                        for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                            httpGet.addHeader(elem.getKey(), elem.getValue());
                        }
                    }
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block12;
                    inputStream = entity.getContent();
                    if (httpClient == null) break block13;
                }
                catch (Exception ex) {
                    try {
                        long end = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end));
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (httpClient != null) {
                            HttpClientUtils.closeQuietly((HttpClient)httpClient);
                        }
                        long end = System.currentTimeMillis() - start;
                        MDC.put((String)"executeTime", (String)String.valueOf(end));
                        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
                        throw throwable;
                    }
                }
                HttpClientUtils.closeQuietly((HttpClient)httpClient);
            }
            long end = System.currentTimeMillis() - start;
            MDC.put((String)"executeTime", (String)String.valueOf(end));
            log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
            return inputStream;
        }
        if (httpClient != null) {
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
        return null;
    }

    public static String doHttpsGetForBase64(String url, Map<String, Object> params, Map<String, String> headerMap) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuffer param;
        long start;
        block20: {
            start = System.currentTimeMillis();
            param = new StringBuffer();
            int i = 0;
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    ++i;
                    param.append(key).append("=").append(params.get(key));
                }
            }
            apiUrl = url + param;
            result = null;
            CloseableHttpResponse response = null;
            Object httpStr = null;
            statusCode = -999;
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                if (headerMap != null) {
                    for (Map.Entry<String, String> elem : headerMap.entrySet()) {
                        httpGet.addHeader(elem.getKey(), elem.getValue());
                    }
                }
                response = httpClient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block20;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
                    if (url.contains("thirdcheck/downloadEInvoice")) {
                        log.info("result.length:{}", (Object)result.length());
                    } else {
                        log.info("result:{}", new Object[]{result});
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{apiUrl, JSON.toJSONString((Object)param), statusCode, end});
        if (url.contains("thirdcheck/downloadEInvoice")) {
            log.info("result.length:{}", (Object)result.length());
        } else {
            log.info("result:{}", new Object[]{result});
        }
        return result;
    }

    public static String doGet(String url, String json) {
        int statusCode;
        String result;
        long start;
        block10: {
            start = System.currentTimeMillis();
            result = null;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGetWithEntity httpGetWithEntity = new HttpGetWithEntity(url);
                StringEntity httpEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
                httpGetWithEntity.setEntity((HttpEntity)httpEntity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGetWithEntity);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = Base64.encode((InputStream)instream);
                }
                if (httpClient == null) break block10;
            }
            catch (Exception ex) {
                try {
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "HttpUtil get error:" + ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (httpClient != null) {
                        HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    }
                    long end = System.currentTimeMillis() - start;
                    MDC.put((String)"executeTime", (String)String.valueOf(end));
                    log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{url, json, statusCode, end});
                    if (!url.contains("office/pdf/export")) {
                        log.info("result:{}", new Object[]{result});
                    } else {
                        log.info("result.length:{}", result != null ? Integer.valueOf(result.length()) : "null");
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        long end = System.currentTimeMillis() - start;
        MDC.put((String)"executeTime", (String)String.valueOf(end));
        log.info("request to:{},param:{},response code:{},cost {} ms", new Object[]{url, json, statusCode, end});
        if (!url.contains("office/pdf/export")) {
            log.info("result:{}", new Object[]{result});
        } else {
            log.info("result.length:{}", result != null ? Integer.valueOf(result.length()) : "null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJyxxPost(String jsonStr, String contentType, String url, String jkname, String bh, String ticket) {
        String responseContent = null;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/json;charset=UTF-8";
        }
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient closeHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();
        httpPost.setConfig(config);
        httpPost.addHeader("Content-Type", contentType);
        if (StringUtils.isNotBlank((CharSequence)ticket)) {
            httpPost.addHeader("Authorization", "BasicAuth " + ticket);
        }
        if (jsonStr != null) {
            StringEntity stringEntity = new StringEntity(jsonStr, CHARSET);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        try {
            if (closeableHttpClient != null) {
                httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                HttpEntity httpEntity = httpResponse.getEntity();
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
                Object parse = null;
                parse = url.contains("bwyd") ? responseContent : JSON.parse((String)responseContent);
                if (parse != null) {
                    responseContent = parse.toString();
                }
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
            responseContent = e.getMessage();
        }
        finally {
            try {
                if (closeHttpClient != null) {
                    closeHttpClient.close();
                }
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendJyxxGet(String url, String ticket) {
        String responseContent = null;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient closeHttpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).setConnectionRequestTimeout(120000).build();
        httpGet.setConfig(config);
        if (StringUtils.isNotBlank((CharSequence)ticket)) {
            httpGet.addHeader("Authorization", "BasicAuth " + ticket);
        }
        try {
            if (closeableHttpClient != null) {
                httpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                HttpEntity httpEntity = httpResponse.getEntity();
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
                Object parse = null;
                parse = url.contains("bwyd") ? responseContent : JSON.parse((String)responseContent);
                if (parse != null) {
                    responseContent = parse.toString();
                }
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
            responseContent = e.getMessage();
        }
        finally {
            try {
                if (closeHttpClient != null) {
                    closeHttpClient.close();
                }
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpClientPost(String url, String contentType, Map<String, String> param, Map<String, String> header, HttpEntity entity) {
        String result = "";
        String bh = PublicUtil.hex32();
        log.info("bh:{},httpClientPost,\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{}httpClientPost param: {} URL:{} header:{}", new Object[]{bh, LocalDateTime.now(), JSON.toJSONString(param), url, JSON.toJSONString(header)});
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                httpPost.setHeader("Content-Type", contentType);
            }
            if (MapUtils.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(param)) {
                ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formparams, Consts.UTF_8);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if (entity != null) {
                httpPost.setEntity(entity);
            }
            try (CloseableHttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);){
                int n = httpResponse.getStatusLine().getStatusCode();
                if (n == 200) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)httpEntity);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            try {
                closeableHttpClient.close();
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        log.info("httpClientPost\u8bf7\u6c42result:{}", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpRequest(HttpMethodEnum method, String url, String token, String content) {
        String responJson = null;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        InputStream inputStream = null;
        KeyStore trustStore = null;
        SSLContext sslcontext = null;
        try {
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            X509HostnameVerifier hostnameVerifier = new X509HostnameVerifier(){

                public void verify(String s, SSLSocket sslSocket) throws IOException {
                }

                public void verify(String s, X509Certificate x509Certificate) throws SSLException {
                }

                public void verify(String s, String[] strings, String[] strings1) throws SSLException {
                }

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext, hostnameVerifier)).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            httpClient = HttpClients.createDefault();
            String uri = url;
            HttpRequestBase httpReq = HttpUtil.getRequestEntity(method, token, uri, content);
            httpResponse = httpClient.execute((HttpUriRequest)httpReq);
            inputStream = httpResponse.getEntity().getContent();
            responJson = HttpUtil.convertToString(inputStream);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return responJson;
    }

    public static String httpHeaderPost(String jsonStr, String contentType, String url, Map<String, String> header) {
        return HttpUtil.httpHeaderPost(jsonStr, contentType, url, header, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpHeaderPost(String jsonStr, String contentType, String url, Map<String, String> header, String jkname, String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = PublicUtil.hex32();
        }
        log.info("{}:\u63a5\u53e3\u5f00\u59cb\u8c03\u7528\u65f6\u95f4\uff1a{},httpHeaderPost,jsonStr: {} URL:{} contentType:{} header:{}", new Object[]{id, LocalDateTime.now(), jsonStr, url, contentType, header});
        String responseContent = null;
        CloseableHttpClient closeableHttpClient = null;
        try {
            closeableHttpClient = HttpClients.createDefault();
        }
        catch (Exception e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = "application/json;charset=UTF-8";
        }
        CloseableHttpResponse httpResponse = null;
        CloseableHttpClient closeHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", contentType);
        if (MapUtils.isNotEmpty(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            StringEntity stringEntity = new StringEntity(jsonStr, CHARSET);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        try {
            if (closeableHttpClient != null) {
                httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
                HttpEntity httpEntity = httpResponse.getEntity();
                responseContent = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
            }
        }
        catch (IOException e) {
            log.error("http\u8bf7\u6c42\u9519\u8bef\uff1a" + e);
            responseContent = e.getMessage();
        }
        finally {
            try {
                if (closeHttpClient != null) {
                    closeHttpClient.close();
                }
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        log.info("{}:\u63a5\u53e3\u7ed3\u675f\u8c03\u7528\u65f6\u95f4\uff1a{},httpHeaderPost,URL:{} responseContent:{}", new Object[]{id, LocalDateTime.now(), url});
        return responseContent;
    }

    private static HttpRequestBase getRequestEntity(HttpMethodEnum method, String token, String uri, String content) throws UnsupportedEncodingException {
        switch (method.getNum()) {
            case 1: {
                HttpGet httpGet = new HttpGet(uri + content);
                httpGet.addHeader("Content-type", "application/json");
                httpGet.addHeader("X-Subject-Token", token);
                return httpGet;
            }
            case 2: {
                HttpPost httpPost = new HttpPost(uri);
                httpPost.addHeader("Content-type", "application/json");
                httpPost.addHeader("X-Subject-Token", token);
                httpPost.setEntity((HttpEntity)new StringEntity(content, CHARSET));
                return httpPost;
            }
            case 3: {
                HttpPut httpPut = new HttpPut(uri);
                httpPut.addHeader("Content-type", "application/json");
                httpPut.addHeader("X-Subject-Token", token);
                httpPut.setEntity((HttpEntity)new StringEntity(content, CHARSET));
                return httpPut;
            }
            case 4: {
                HttpDelete httpDelete = new HttpDelete(uri + content);
                httpDelete.addHeader("Content-type", "application/json");
                httpDelete.addHeader("X-Subject-Token", token);
                return httpDelete;
            }
        }
        System.out.println("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5bf9");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadFile(String fileUrl) {
        byte[] bytes = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setConnectTimeout(5000);
            http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
            inputStream = http.getInputStream();
            if (inputStream != null) {
                bytes = FileUtils.convertToByteArray(inputStream);
                inputStream.close();
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertToString(InputStream is) {
        String string;
        if (is == null) {
            return null;
        }
        BufferedReader bf = null;
        try {
            StringBuilder sb = new StringBuilder();
            String temp = "";
            bf = new BufferedReader(new InputStreamReader(is, CHARSET));
            while ((temp = bf.readLine()) != null) {
                sb.append(temp);
            }
            string = sb.toString();
            HttpUtil.closeStream(bf);
        }
        catch (IOException e) {
            e.printStackTrace();
            String string2 = null;
            return string2;
        }
        finally {
            HttpUtil.closeStream(bf);
            HttpUtil.closeStream(is);
        }
        HttpUtil.closeStream(is);
        return string;
    }

    private static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(120000);
        configBuilder.setSocketTimeout(300000);
        configBuilder.setConnectionRequestTimeout(120000);
        requestConfig = configBuilder.build();
    }
}

