package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyPj;

/**
 * (GxYyPj)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYyPjRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyPj get(String id);

    /**
     * 新增数据
     *
     * @param gxYyPj 实例对象
     * @return 影响行数
     */
    void save(GxYyPj gxYyPj);

    /**
     * 新增或更新数据
     *
     * @param gxYyPj 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyPj gxYyPj);

    /**
     * 修改数据
     *
     * @param gxYyPj 实例对象
     * @return 影响行数
     */
    void update(GxYyPj gxYyPj);

    /**
     * 根据受理编号和评价人guid获取评价
     *
     * @param slbh 受理编号
     * @param slbh userGuid
     */
    GxYyPj getBySlbhAndEvaluator(String slbh, String userGuid);
}

