package cn.gtmap.hlw.core.dto.third.cfxx;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2024/3/5
 * @description 查封信息保存
 */
@Data
public class CfxxSaveDTO {

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 查封机构
     */
    private String cfjg;

    /**
     * 查封类型
     */
    private String cflx;

    /**
     * 查封文号
     */
    private String cfwh;

    /**
     * 查封开始时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cfkssj;

    /**
     * 查封结束时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cfjssj;

    /**
     * 登记时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date djsj;

    /**
     * 权属状态
     */
    private String qszt;

    /**
     * 附记
     */
    private String fj;

    /**
     * 产权来源
     */
    private String cqly;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 被查封人
     */
    private String bcfr;

    /**
     * 查封范围
     */
    private String cffw;

    /**
     * 查封文件
     */
    private String cfwj;

    /**
     * 证书来源
     */
    private String zsly;

    /**
     * xmid
     */
    private String xmid;

    /**
     * 宗地宗海面积
     */
    private String zdzhmj;

    /**
     * 宗地用途
     */
    private String zdyt;

    /**
     * 宗地用途名称
     */
    private String zdytmc;

    /**
     * 宗地权利性质
     */
    private String zdqlxz;

    /**
     * 宗地权利性质名称
     */
    private String zdqlxzmc;

    /**
     * 房屋结构
     */
    private String fwjg;

    /**
     * 房屋结构名称
     */
    private String fwjgmc;

    /**
     * 总层数
     */
    private String zcs;

    /**
     * 所在层
     */
    private String szc;

    /**
     * 房屋性质
     */
    private String fwxz;

    /**
     * 房屋性质名称
     */
    private String fwxzmc;

    /**
     * 房屋类型
     */
    private String fwlx;

    /**
     * 房屋类型名称
     */
    private String fwlxmc;

    /**
     * 规划用途
     */
    private String ghyt;

    /**
     * 规划用途名称
     */
    private String ghytmc;

    /**
     * 不动产类型
     */
    private String bdclx;

    /**
     * 不动产类型名称
     */
    private String bdclxmc;

    /**
     * 房屋面积
     */
    private String mj;

    /**
     * 行政区代码
     */
    private String xzqdm;

    /**
     * 权利人list
     */
    private List<CfxxQlrxxSaveDTO> qlrList;

}
