package cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy;


import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 2024/4/8 13:36
 * @description 登记3.0 转移抵押合并流程创建入参
 */
@Data
public class PushDj3DyZyParamsBO {

    /**
     * 业务号
     */
    private String ywh;

    /**
     * 申请登记类型
     */
    private String sqdjlx;

    /**
     * 是否自动创建(1自动创建，0手动创建)
     */
    private String sfcj;

    /**
     * 预约部门编码
     */
    private String yybmbm;

    /**
     * 行政区代码
     */
    private String xzqdm;

    /**
     * 证书来源
     */
    private String zsly;

    /**
     * 是否涉税(0 不涉税，1涉税)
     */
    private String sfss;

    /**
     * 不动产单元信息
     */
    @ZdDzConfig(field = "bdcdyxx", tableName = "", isList = true)
    private List<PushDj3DyZyBdcdyParamsBO> bdcdyxx;

    /**
     * 预审提示信息
     */
    private String ystsxx;

    /**
     * 送达时间
     */
    private Date sdss;

    /**
     * 预审人
     */
    private String ysr;

    /**
     * 预审时间
     */
    private String yssj;

    /**
     * 预约开始时间
     */
    private String yykssj;

    /**
     * 预约结束时间
     */
    private String yyjssj;

    /**
     * 申请人id
     */
    private String sqrid;

    /**
     * 是否自动转发向审核节点 0不转发 1转发
     */
    private String zdzf;

    /**
     * 创建人角色名称
     */
    private String cjrjsmc;

    /**
     * 跳过节点数
     */
    private String tgjds;

    /**
     * 受理来源 (互联网+非银行：3，互联网+银行：6（3.0）)
     */
    private String slly;

    /**
     * 受理人
     */
    /**
     * 受理人
     */
    @ZdDzConfig(field = "slr", tableName = ZdDzConstant.ZD_DZ_SLR, dmToDm = true)
    private String slr;

    /**
     * 申请人证件号
     */
    private String sqrzjh;

    /**
     * 银行复审人
     */
    private String fsr;

    /**
     * 银行登簿人
     */
    private String dbr;

    /**
     * 是否税费托管（1:是，0：否）
     */
    private String sfsftg;

    /**
     * 申请部门名称
     */
    private String sqbmmc;
    /**
     * 业务类型
     */
    private String ywlx;

    /**
     * 是否一次收费后台分账（1:是，0：否）
     */
    private String sfycsfhtfz;

    /**
     * 是否分别持证
     */
    private String sffbcz;
    /**
     * 31	完税证明获取方式代码
     */
    private String wszmhqfsdm;

    /**
     * 32	是否选择云签
     */
    private String sfxzyq;
    /**
     * 创建人角色id
     */
    private String cjrjsid;
    /**
     * 创建人名称
     */
    private String cjrmc;
    /**
     * 权利人ocr识别是否通过
     */
    private String qlrocrsbsftg;

}
