/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.aop;

import cn.gtmap.hlw.core.annotation.ApiVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionCondition
implements RequestCondition<ApiVersionCondition> {
    private static final Logger logger = LoggerFactory.getLogger(ApiVersionCondition.class);
    private static final Pattern VERSION_PREFIX_PATTERN = Pattern.compile("/v([0-9]+\\.{0,1}[0-9]{0,2})/");
    private ApiVersion apiVersion;

    ApiVersionCondition(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionCondition combine(ApiVersionCondition other) {
        return new ApiVersionCondition(other.getApiVersion());
    }

    public ApiVersionCondition getMatchingCondition(HttpServletRequest httpServletRequest) {
        logger.info("\u83b7\u53d6URI\uff1a{}", (Object)httpServletRequest.getRequestURI());
        Matcher m = VERSION_PREFIX_PATTERN.matcher(httpServletRequest.getRequestURI());
        if (m.find()) {
            logger.info("groupCount\uff1a{}", (Object)m.groupCount());
            String group = String.valueOf(m.group(1));
            double version = Double.parseDouble(group);
            if (version >= this.getApiVersion().version()) {
                return this;
            }
        }
        return null;
    }

    public int compareTo(ApiVersionCondition other, HttpServletRequest httpServletRequest) {
        return other.getApiVersion().version() >= this.getApiVersion().version() ? 1 : -1;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }
}

